﻿---
title: Index lifecycle management phases and actions
description: Index lifecycle management (ILM) in Elasticsearch defines how indices transition through different phases—hot, warm, cold, frozen, and delete—based on...
url: https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/index-lifecycle
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Index lifecycle management phases and actions
Index lifecycle management (ILM) in Elasticsearch defines how indices transition through different phases—hot, warm, cold, frozen, and delete—based on age and usage. Each phase supports specific actions, from rollover and force merge to searchable snapshots and delete. This guide explains the purpose of each phase, the timing of transitions, and the actions available to manage index performance and storage efficiently.
[Index lifecycle management](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management) (ILM) defines five index lifecycle *phases*:
- **Hot**: The index is actively being updated and queried.
- **Warm**: The index is updated infrequently or not at all, but is still being queried.
- **Cold**: The index is updated infrequently or not at all, and is also queried infrequently. The information still needs to be searchable, but it’s okay if those queries are slower.
- **Frozen**: The index is no longer being updated and is queried rarely. The information still needs to be searchable, but it’s okay if those queries are extremely slow.
- **Delete**: The index is no longer needed and can safely be removed.

An index’s *lifecycle policy* specifies which phases are applicable, what actions are performed in each phase, and when it transitions between phases.
You can manually apply a lifecycle policy when you create an index. For time series indices, you need to associate the lifecycle policy with the index template used to create new indices in the series. When an index rolls over, a manually-applied policy isn’t automatically applied to the new index.
If you use Elasticsearch's security features, ILM performs operations as the user who last updated the policy. ILM only has the [roles](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/defining-roles) assigned to the user at the time of the last policy update.

## Phase transitions

ILM moves indices through the lifecycle according to their age. To control the timing of these transitions, you set a *minimum age* for each phase. For an index to move to the next phase, all actions in the current phase must be complete and the index must be older than the minimum age of the next phase. Configured minimum ages must increase between subsequent phases, for example, a "warm" phase with a minimum age of 10 days can only be followed by a "cold" phase with a minimum age either unset, or >= 10 days.
The minimum age defaults to zero, which causes ILM to move indices to the next phase as soon as all actions in the current phase complete.
<note>
  If an index has been [rolled over](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-rollover), then the `min_age` value is relative to the time the index was rolled over, not the index creation time. [Learn more](/docs/troubleshoot/elasticsearch/index-lifecycle-management-errors#min-age-calculation).
</note>

If an index has unallocated shards and the [cluster health status](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-health) is yellow, the index can still transition to the next phase according to its index lifecycle management policy. However, because Elasticsearch can only perform certain clean up tasks on a green cluster, there might be unexpected side effects.
To avoid increased disk usage and reliability issues, address any cluster health problems in a timely fashion.

## Phase execution

ILM controls the order in which the actions in a phase are executed and what *steps* are executed to perform the necessary index operations for each action.
When an index enters a phase, ILM caches the phase definition in the index metadata. This ensures that policy updates don’t put the index into a state where it can never exit the phase. If changes can be safely applied, ILM updates the cached phase definition. If they cannot, phase execution continues using the cached definition.
ILM runs periodically, checks to see if an index meets policy criteria, and executes whatever steps are needed. To avoid race conditions, ILM might need to run more than once to execute all of the steps required to complete an action. For example, if ILM determines that an index has met the rollover criteria, it begins executing the steps required to complete the rollover action. If it reaches a point where it is not safe to advance to the next step, execution stops. The next time ILM runs, ILM picks up execution where it left off. This means that even if `indices.lifecycle.poll_interval` is set to 10 minutes and an index meets the rollover criteria, it could be 20 minutes before the rollover is complete.

## Phase actions

ILM supports the following actions in each phase. The order in which actions are performed varies for different lifecycle phase. Refer to the [Phases and available actions](#phases-availability) table for a summary of the phases for which each action is available.

### Hot phase

The following actions are available in the `hot` lifecycle phase. Actions are performed in the order listed.

| Action                                                                                                                     | Description                                                                                                                                                                                                                            |
|----------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [Set priority](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-set-priority)               | Sets the priority level of the index, which determines the order in which indices are recovered following a node restart.                                                                                                              |
| [Unfollow](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-unfollow)                       | Converts a [CCR](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-ccr) follower index into a regular index, enabling the shrink, rollover, and searchable snapshot actions to be performed safely on follower indices. |
| [Rollover](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-rollover)                       | Rolls over a target to a new index when the existing index satisfies the specified rollover conditions.                                                                                                                                |
| [Read-only](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-readonly)                      | Makes the index data read-only, disabling data write operations against it.                                                                                                                                                            |
| [Downsample](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-downsample)                   | Aggregates a time series (TSDS) index and stores pre-computed statistical summaries (min, max, sum, value_count and avg) for each metric field grouped by a configured time interval.                                                  |
| [Shrink](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-shrink)                           | Blocks write operations on a source index and shrinks it into a new index with fewer primary shards.                                                                                                                                   |
| [Force merge](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-forcemerge)                  | Reduces the number of segments in each shard by merging some of them together.                                                                                                                                                         |
| [Searchable snapshot](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-searchable-snapshot) | Takes a snapshot of the managed index in the configured repository and mounts it as a [searchable snapshot](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/searchable-snapshots).                                |


### Warm phase

The following actions are available in the `warm` lifecycle phase. Actions are performed in the order listed.

| Action                                                                                                       | Description                                                                                                                                                                                                                            |
|--------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [Set priority](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-set-priority) | Sets the priority level of the index, which determines the order in which indices are recovered following a node restart.                                                                                                              |
| [Unfollow](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-unfollow)         | Converts a [CCR](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-ccr) follower index into a regular index, enabling the shrink, rollover, and searchable snapshot actions to be performed safely on follower indices. |
| [Read-only](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-readonly)        | Makes the index data read-only, disabling data write operations against it.                                                                                                                                                            |
| [Downsample](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-downsample)     | Aggregates a time series (TSDS) index and stores pre-computed statistical summaries (`min`, `max`, `sum`, `value_count`, and `avg`) for each metric field grouped by a configured time interval.                                       |
| [Allocate](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-allocate)         | Updates the index settings to change which nodes are allowed to host the index shards and change the number of replicas.                                                                                                               |
| [Migrate](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-migrate)           | Moves the index to the [data tier](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers) that corresponds to the current phase by updating the `index.routing.allocation.include._tier_preference` index setting.              |
| [Shrink](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-shrink)             | Blocks writes on a source index and shrinks it into a new index with fewer primary shards.                                                                                                                                             |
| [Force merge](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-forcemerge)    | Reduces the number of segments in each shard by merging some of them together.                                                                                                                                                         |


### Cold phase

The following actions are available in the `cold` lifecycle phase. Actions are performed in the order listed.

| Action                                                                                                                     | Description                                                                                                                                                                                                                            |
|----------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [Set priority](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-set-priority)               | Sets the priority level of the index, which determines the order in which indices are recovered following a node restart.                                                                                                              |
| [Unfollow](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-unfollow)                       | Converts a [CCR](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-ccr) follower index into a regular index, enabling the shrink, rollover, and searchable snapshot actions to be performed safely on follower indices. |
| [Read-only](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-readonly)                      | Makes the index data read-only, disabling data write operations against it.                                                                                                                                                            |
| [Downsample](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-downsample)                   | Aggregates a time series (TSDS) index and stores pre-computed statistical summaries (min, max, sum, value_count and avg) for each metric field grouped by a configured time interval.                                                  |
| [Searchable snapshot](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-searchable-snapshot) | Takes a snapshot of the managed index in the configured repository and mounts it as a [searchable snapshot](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/searchable-snapshots).                                |
| [Allocate](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-allocate)                       | Updates the index settings to change which nodes are allowed to host the index shards and change the number of replicas.                                                                                                               |
| [Migrate](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-migrate)                         | Moves the index to the [data tier](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers) that corresponds to the current phase by updating the `index.routing.allocation.include._tier_preference` index setting.              |


### Frozen phase

The following actions are available in the `frozen` lifecycle phase. Actions are performed in the order listed.

| Action                                                                                                                     | Description                                                                                                                                                                                                                            |
|----------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [Unfollow](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-unfollow)                       | Converts a [CCR](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-ccr) follower index into a regular index, enabling the shrink, rollover, and searchable snapshot actions to be performed safely on follower indices. |
| [Searchable snapshot](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-searchable-snapshot) | Takes a snapshot of the managed index in the configured repository and mounts it as a [searchable snapshot](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/searchable-snapshots).                                |


### Delete phase

The following actions are available in the `delete` lifecycle phase. Actions are performed in the order listed.

| Action                                                                                                                 | Description                                                                                                                                                              |
|------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [Wait for snapshot](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-wait-for-snapshot) | Waits for the specified snapshot lifecycle management (SLM) policy to be executed before removing the index, ensuring that a snapshot of the deleted index is available. |
| [Delete](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-delete)                       | Permanently removes the index.                                                                                                                                           |


### Phases and available actions

The following table summarizes the actions available in each phase.

| Action                                                                                                                     | `Hot` | `Warm` | `Cold` | `Frozen` | `Delete` |
|----------------------------------------------------------------------------------------------------------------------------|-------|--------|--------|----------|----------|
| [Allocate](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-allocate)                       | ❌     | ✅      | ✅      | ❌        | ❌        |
| [Delete](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-delete)                           | ❌     | ❌      | ❌      | ❌        | ✅        |
| [Downsample](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-downsample)                   | ✅     | ✅      | ✅      | ❌        | ❌        |
| [Force merge](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-forcemerge)                  | ✅     | ✅      | ❌      | ❌        | ❌        |
| [Migrate](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-migrate)                         | ❌     | ✅      | ✅      | ❌        | ❌        |
| [Read-only](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-readonly)                      | ✅     | ✅      | ✅      | ❌        | ❌        |
| [Rollover](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-rollover)                       | ✅     | ❌      | ❌      | ❌        | ❌        |
| [Searchable snapshot](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-searchable-snapshot) | ✅     | ❌      | ✅      | ✅        | ❌        |
| [Set priority](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-set-priority)               | ✅     | ✅      | ✅      | ❌        | ❌        |
| [Shrink](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-shrink)                           | ✅     | ✅      | ❌      | ❌        | ❌        |
| [Unfollow](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-unfollow)                       | ✅     | ✅      | ✅      | ✅        | ❌        |
| [Wait for snapshot](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-wait-for-snapshot)     | ❌     | ❌      | ❌      | ❌        | ✅        |