﻿---
title: ILM automation tutorials
description: A collection of tutorials is available to help you control the lifecycle of your data using index lifecycle management. index lifecycle management (ILM)...
url: https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/ilm-tutorials
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# ILM automation tutorials
A collection of tutorials is available to help you control the lifecycle of your data using index lifecycle management.

## Configuring rollover

index lifecycle management (ILM) in Elasticsearch is a powerful feature that helps automate the management of your indices through their entire lifecycle — from creation to rollover, to retention and deletion. Whether you're handling large volumes of time series data or general content, ILM enables you to optimize performance, control storage costs, and enforce data retention policies with ease. These tutorials guide you step-by-step through setting up ILM policies, configuring automated rollover, and monitoring your indices, so you can efficiently manage your Elasticsearch data lifecycle.
When you continuously index timestamped documents into Elasticsearch, you typically use a [data stream](https://www.elastic.co/docs/manage-data/data-store/data-streams) so you can periodically [roll over](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/rollover) to a new index. To simplify index management and automate rollover, select one of the scenarios that best applies to your situation:
- **Roll over data streams with ILM.** When ingesting write-once, timestamped data that doesn't change, follow the steps in [Manage time series data with data streams](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/tutorial-time-series-with-data-streams) for simple, automated data stream rollover. ILM-managed backing indices are automatically created under a single data stream alias. ILM also tracks and transitions the backing indices through the lifecycle automatically.
- **Roll over time series indices with ILM.** Data streams are best suited for [append-only](/docs/manage-data/data-store/data-streams#data-streams-append-only) use cases. If you need to update or delete existing time series data, you can perform update or delete operations directly on the data stream backing index. If you frequently send multiple documents using the same `_id` expecting last-write-wins, you may want to use an index alias with a write index instead. You can still use ILM to manage and roll over the alias’s indices. Follow the steps in [Manage time series data without data streams](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/tutorial-time-series-without-data-streams) for more information.
- **Roll over general content as data streams with ILM.** If some of your indices store data that isn't timestamped, but you would like to get the benefits of automatic rotation when the index reaches a certain size or age, or delete already rotated indices after a certain amount of time, follow the steps in [Manage general content with data streams](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/tutorial-general-content-with-data-streams). These steps include injecting a timestamp field during indexing time to mimic time series data.


## Customizing a built-in ILM policy

When your data streams have been set up automatically, for example when you're ingesting data by means of an [Elastic integration](https://docs.elastic.co/en/integrations), the data is typically managed using a built-in ILM policy. To customize the lifecycle policy for managed indices, refer to: [Customize built-in ILM policies in Elasticsearch](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/tutorial-customize-built-in-policies).