﻿---
title: Create an index lifecycle management policy in Elasticsearch
description: An index lifecycle management (ILM) policy defines how indices transition through different phases over time. This guide explains how to create a new...
url: https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/configure-lifecycle-policy
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Create an index lifecycle management policy in Elasticsearch
An [index lifecycle management](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management) (ILM) policy defines how indices transition through different phases over time. This guide explains how to create a new ILM policy with configurable rollover, retention, and deletion rules, and then apply the policy using an index template.
You can use ILM to manage both indices and [data streams](https://www.elastic.co/docs/manage-data/data-store/data-streams). There are fewer configuration steps required to set up ILM with data streams. In comparison, configuring ILM with indices requires you to create an initial managed index and alias in addition to defining a policy and creating a template to apply it. This page describes the steps to configure an ILM lifecycle policy for both scenarios.
<note>
  This page is specifically about using ILM with indices or data streams. If you're looking for a simpler data streams lifecycle management option that focuses on a data retention period, refer to [Data stream lifecycle](https://www.elastic.co/docs/manage-data/lifecycle/data-stream). Check [Data lifecycle](https://www.elastic.co/docs/manage-data/lifecycle) to compare these lifecycle management options.
</note>

**Consider these aspects when creating an ILM policy:**
- To manage an index or data stream with ILM, you need to specify a valid policy in the `index.lifecycle.name` index setting.
- To configure a lifecycle policy for [rolling indices](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/rollover) or data streams, you create the policy and add it to the [index template](https://www.elastic.co/docs/manage-data/data-store/templates). Data streams are generally recommended in favor of rolling indices due to the lesser amount of manual configuration required. When you use ILM with rolling indices, you must, additionally, create an initial managed index (ensuring that it is named appropriately) and assign an alias to it. This additional process is described in [Step 3](#create-initial-index) on this page.
- To use a policy to manage a single index, you can specify a lifecycle policy when you create the index, or apply a policy directly to an existing index.
- ILM policies are stored in the global cluster state and can be included in snapshots by setting `include_global_state` to `true` when you [take the snapshot](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/create-snapshots). When the snapshot is restored, all of the policies in the global state are restored and any local policies with the same names are overwritten.


## Overview

To set up ILM to manage one or more indices, the general procedure is as follows:
1. [Create a lifecycle policy](#ilm-create-policy)
2. [Create an index template to apply the lifecycle policy](#apply-policy-template)

If you're configuring ILM for rolling indices and not using [data streams](https://www.elastic.co/docs/manage-data/data-store/data-streams), you additionally need to:
1. [Create an initial managed index and alias](#create-initial-index)

You can perform these actions in Kibana or using the Elasticsearch API.

## Create a lifecycle policy

A lifecycle policy defines a set of index lifecycle phases and the actions to perform on the managed indices in each phase.
<tab-set>
  <tab-item title="Kibana">
    To add an ILM policy to an Elasticsearch cluster:
    1. Go to the **Index Lifecycle Policies** management page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
    2. Select **Create policy**.
       ![Create policy page](https://www.elastic.co/docs/manage-data/images/elasticsearch-reference-create-policy.png)
    3. Specify a name for the lifecycle policy. Later on, when you create an index template to define how indices are created, you'll use this name to assign the lifecycle policy to each index.
    4. In the **Hot phase**, a [rollover index lifecycle action](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-rollover) is executed by default when either:
       - The index reaches 30 days of age.
    - One or more primary shards reach 50 GB in size.
       Disable **Use recommended defaults** to adjust these values or to roll over based on the size of the primary shard, the number of documents in the primary shard, or the total number of documents in the index.
       <important>
       The rollover action implicitly rolls over a data stream or alias if one or more shards contain 200,000,000 or more documents. Typically, a shard will reach 50GB before it reaches 200M documents, however, this isn’t the case for space efficient data sets. This built-in limit exists to avoid Search performance loss if a shard contains more than 200M documents. For more information about recommended limits, refer to [Size your shards](https://www.elastic.co/docs/deploy-manage/production-guidance/optimize-performance/size-shards).
       </important>
    5. By default, only the hot index lifecycle phase is enabled. Enable each additional lifecycle phase that you'd like, and for each choose any [index lifecycle actions](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions) to perform on indices when they enter that phase.
       For example, you could choose the action to [downsample](https://www.elastic.co/docs/manage-data/data-store/data-streams/downsampling-time-series-data-stream) the index, which aggregates the time series data into statistical summaries, reducing the data storage size.
       ![Create policy page](https://www.elastic.co/docs/manage-data/images/elasticsearch-reference-create-policy-downsample.png)
       <note>
       For each phase after the hot phase, you have the option to move the data into the next phase after a certain duration of time. This duration is calculated from the time of the index rollover and not from the time the index is created.
       </note>
    6. For the final phase that's enabled, choose to either keep the data in the phase forever or delete the data after a specified period of time.
  </tab-item>

  <tab-item title="API">
    Use the [Create or update policy](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ilm-put-lifecycle) API to add an ILM policy to the Elasticsearch cluster:
    ```json

    {
      "policy": {
        "phases": {
          "hot": {
            "actions": {
              "rollover": {
                "max_primary_shard_size": "25GB" <1>
              }
            }
          },
          "delete": {
            "min_age": "30d",
            "actions": {
              "delete": {} <2>
            }
          }
        }
      }
    }
    ```

    <important>
      The rollover action implicitly rolls over a data stream or alias if one or more shards contain 200,000,000 or more documents. Typically, a shard will reach 50GB before it reaches 200M documents, however, this isn’t the case for space efficient data sets. This built-in limit exists to avoid Search performance loss if a shard contains more than 200M documents.
    </important>
  </tab-item>
</tab-set>


## Create an index template to apply the lifecycle policy

To use a lifecycle policy that triggers a rollover action, you need to configure the policy in the index template used to create each new index. You specify the name of the policy and the alias used to reference the rolling indices.
<tip>
  If you already have an index template to which you'd like to add an ILM policy, you can do this from the **Index Lifecycle Policies** management page. Search for and select the policy you want, and from the **Actions** menu, select **Add to index template**.
</tip>

<tab-set>
  <tab-item title="Kibana">
    To add an index template to a cluster and apply the lifecycle policy to indices matching the template:
    1. Go to the **Index Management** page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
    2. In the **Index Templates** tab, select **Create template**.
       ![Create template page](https://www.elastic.co/docs/manage-data/images/elasticsearch-reference-create-template-wizard-my_template.png)
    3. On the **Logistics** page:
       1. Specify a name for the template.
    2. Specify a pattern to match the indices you want to manage with the lifecycle policy. For example, `my-index-*`.
    3. If you're storing continuously generated, append-only data, you can opt to create [data streams](https://www.elastic.co/docs/manage-data/data-store/data-streams) instead of indices for more efficient storage.
       <note>
       When you enable the data stream option, an option to set **Data retention** also becomes available. Since you're creating an index lifecycle policy to manage indices, the  **Data retention** option must remain disabled. Data retention is applicable only if you're using a data stream lifecycle, which is an alternative to ILM. Refer to the [Data stream lifecycle](https://www.elastic.co/docs/manage-data/lifecycle/data-stream) to learn more.
       </note>
    4. Configure any other options you'd like, including:
       - The [index mode](https://www.elastic.co/docs/reference/elasticsearch/index-settings/time-series) to use for the created indices.
    - The template priority, version, and any metadata.
    - Whether or not to overwrite the `action.auto_create_index` cluster setting.
       Refer to the [Create or update index template API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-index-template) documentation for details about these options.
    4. On the **Component templates** page, use the search and filter tools to select any [component templates](/docs/manage-data/data-store/templates#component-templates) to include in the index template. The index template will inherit the settings, mappings, and aliases defined in the component templates and apply them to indices when they're created.
    5. On the **Index settings** page:
       1. Configure ILM by specifying the [ILM settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/index-lifecycle-management-settings) to apply to the indices:
       - `index.lifecycle.name` - The lifecycle policy to manage the created indices.
    - `index.lifecycle.rollover_alias` - The index [alias](https://www.elastic.co/docs/manage-data/data-store/aliases) used for querying and managing the set of indices associated with a lifecycle policy that contains a rollover action.
      <tip>
      The `index.lifecycle.rollover_alias` setting is required only if you're using index lifecycle management with an alias. It is unnecessary when using [Data Streams](https://www.elastic.co/docs/manage-data/data-store/data-streams).
      </tip>
    2. Optional: Add any additional [index settings](https://www.elastic.co/docs/reference/elasticsearch/index-settings), that should be applied to the indices as they're created. For example, you can set the number of shards and replicas for each index:
       ```json
       {
         "index.lifecycle.name": "my_policy",
         "index.lifecycle.rollover_alias": "test-alias",
         "number_of_shards": 1,
         "number_of_replicas": 1
       }
       ```
    6. Optional: On the **Mappings** page, customize the fields and data types used when documents are indexed into Elasticsearch. Refer to [Mapping](https://www.elastic.co/docs/manage-data/data-store/mapping) for details.
    7. Optional: On the **Aliases** page, specify an [alias](https://www.elastic.co/docs/manage-data/data-store/aliases) for each created index. This isn't required when configuring ILM, which instead uses the `index.lifecycle.rollover_alias` setting to access rolling indices.
    8. On the **Review** page, confirm your selections. You can check your selected options, as well as both the format of the index template that will be created and the associated API request.
    The newly created index template will be used for all new indices with names that match the specified pattern, and for each of these, the specified ILM policy will be applied.
  </tab-item>

  <tab-item title="API">
    Use the [Create or update index template API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-index-template) to add an index template to a cluster and apply the lifecycle policy to indices matching the template:
    ```json

    {
      "index_patterns": ["test-*"], <1>
      "template": {
        "settings": {
          "number_of_shards": 1,
          "number_of_replicas": 1,
          "index.lifecycle.name": "my_policy", <2>
          "index.lifecycle.rollover_alias": "test-alias" <3>
        }
      }
    }
    ```
  </tab-item>
</tab-set>


## Create an initial managed index and alias

When you set up policies for your own rolling indices and are not using the recommended [data streams](https://www.elastic.co/docs/manage-data/data-store/data-streams), you must manually create the first index managed by a policy and designate it as the write index.
The name of the index must match the pattern defined in the index template and end with a number. This number is incremented to generate the name of indices created by the rollover action.
This step is required only when you're planning to use ILM with rolling indices. It is not required when you're using data streams, where the initial managed index is created automatically.
<important>
  When you enable index lifecycle management for Beats, Elastic Agent, or for the Elastic Agent or Logstash Elasticsearch output plugins, the necessary policies and configuration changes are applied automatically. If you'd like to create a specialized ILM policy for any data stream, refer to our tutorial [Customize built-in ILM policies in Elasticsearch](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management/tutorial-customize-built-in-policies).
</important>

<tab-set>
  <tab-item title="Kibana">
    To create the initial managed index:
    1. Go to the **Index Management** page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
    2. In the **Indices** tab, select **Create index**.
    3. Specify a name for the index that matches the index template pattern and that ends with a number. For example, `test-000001`.
    4. Leave the **Index mode** set to the default **Standard**.
    Create an alias for the index:
    1. Open **Dev tools**.
    2. Send the following request:

    ```json

    {
      "actions" : [
        { "add" : { "index" : "my-index", "alias" : "my-alias" } } <1>
      ]
    }
    ```
    Now you can start indexing data to the rollover alias specified in the lifecycle policy. With the sample `my_policy` policy, the rollover action is triggered once the initial index exceeds 50GB. ILM then creates a new index that becomes the write index for the `test-alias`.
  </tab-item>

  <tab-item title="API">
    Use the [Create an index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) to create the initial managed index.The following request creates the `test-000001` index, with the alias `test-alias`. Because the index name matches the index pattern specified in `my_template`, Elasticsearch automatically applies the settings from that template.
    ```json

    {
      "aliases": {
        "test-alias":{
          "is_write_index": true <1>
        }
      }
    }
    ```
    Now you can start indexing data to the rollover alias specified in the lifecycle policy. With the sample `my_policy` policy, the rollover action is triggered once the initial index exceeds 25GB. ILM then creates a new index that becomes the write index for the `test-alias`.
  </tab-item>
</tab-set>