﻿---
title: Update the lifecycle of a data stream
description: Follow these steps to configure or remove data stream lifecycle settings for an existing, individual data stream. Set a data stream’s lifecycle, Remove...
url: https://www.elastic.co/docs/manage-data/lifecycle/data-stream/tutorial-update-existing-data-stream
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Update the lifecycle of a data stream
Follow these steps to configure or remove data stream lifecycle settings for an existing, individual data stream.
- [Set a data stream’s lifecycle](#set-lifecycle)
- [Remove the lifecycle for a data stream](#delete-lifecycle)
- [Manage data retention on the Streams page](#data-retention-streams)

These steps are for data stream lifecycle only. For the steps to configure index lifecycle management, refer to the [ILM documentation](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management). For a comparison between the two, refer to [Data lifecycle](https://www.elastic.co/docs/manage-data/lifecycle).

## Set a data stream’s lifecycle

To add or to change the retention period of your data stream you can use the **Index Management** tools in Kibana or the Elasticsearch [lifecycle API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-data-lifecycle).
<tab-set>
  <tab-item title="Kibana">
    To change the data retention settings for a data stream:
    1. Go to the **Index Management** page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
    2. Open the **Data Streams** tab.
    3. Use the search tool to find the data stream you're looking for.
    4. Select the data stream to view its details.
    5. In the data stream details pane, select **Manage > Edit data retention** to adjust the settings. You can do any of the following:
       - Select how long to retain your data, in days, hours, minutes, or seconds.
    - Choose to **Keep data indefinitely**, so that your data will not be deleted. Your data stream is still managed but the data will never be deleted. Managing a time series data stream such as for logs or metrics enables Elasticsearch to better store your data even if you do not use a retention period.
    - Disable **Enable data retention** to turn off data stream lifecycle management for your data stream.
       If the data stream is already managed by [ILM](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management), to edit the data retention settings you must edit the associated ILM policy.
  </tab-item>

  <tab-item title="API">
    To change the data retention settings for a data stream:
    - You can set infinite retention period, meaning that your data should never be deleted. For example:
      ```json

      { } <1>
      ```
    - Or you can set the retention period of your choice. For example:
      ```json

      {
        "data_retention": "30d" <1>
      }
      ```
  </tab-item>
</tab-set>

The changes in the lifecycle are applied on all backing indices of the data stream.
You can see the effect of the change in Kibana or using the Elasticsearch [explain API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-explain-data-lifecycle):
<tab-set>
  <tab-item title="Kibana">
    To check the data retention settings for a data stream:
    1. Go to the **Index Management** page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
    2. Open the **Data Streams** tab.
    3. Use the search tool to find the data stream you're looking for.
    4. Select the data stream to view its details. The flyout shows the data retention settings for the data stream. If the data stream is currently managed by an [ILM policy](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management), the **Effective data retention** may differ from the retention value that you've set in the data stream, as indicated by the **Data retention**.

    ![Index lifecycle status page](https://www.elastic.co/docs/manage-data/images/elasticsearch-reference-lifecycle-status.png)
  </tab-item>

  <tab-item title="API">
    To check the data retention settings for a data stream:
    ```json
    ```
    The response will look like:
    ```json
    {
      "indices": {
        ".ds-my-data-stream-2023.04.19-000002": {
          "index": ".ds-my-data-stream-2023.04.19-000002",  
          "managed_by_lifecycle": true,                           
          "index_creation_date_millis": 1681919221417,
          "time_since_index_creation": "6.85s",             
          "lifecycle": {
            "enabled": true,
            "data_retention": "30d"                         
          }
        },
        ".ds-my-data-stream-2023.04.17-000001": {
          "index": ".ds-my-data-stream-2023.04.17-000001",  
          "managed_by_lifecycle": true,                           
          "index_creation_date_millis": 1681745209501,
          "time_since_index_creation": "48d",               
          "rollover_date_millis": 1681919221419,
          "time_since_rollover": "6.84s",                   
          "generation_time": "6.84s",                       
          "lifecycle": {
            "enabled": true,
            "data_retention": "30d"                         
          }
        }
      }
    }
    ```
  </tab-item>
</tab-set>


## Remove the lifecycle for a data stream

To remove the lifecycle of a data stream you can use the **Index Management** tools in Kibana or the Elasticsearch [delete lifecycle API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-delete-data-lifecycle).
<tab-set>
  <tab-item title="Kibana">
    To remove a data stream's lifecycle:
    1. Go to the **Index Management** page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
    2. Open the **Data Streams** tab.
    3. Use the search tool to find the data stream you're looking for.
    4. Select the data stream to view its details.
    5. In the data stream details pane, select **Manage > Edit data retention**.
    6. Turn off the **Enable data retention** option and save your changes. The maintenance operations that were applied by the lifecycle will no longer be applied to the data stream and all of its backing indices.
       You can confirm your changes by reopening the data stream pane. The **Effective data retention** will show a **Disabled** status.

    ![Index lifecycle status is disabled](https://www.elastic.co/docs/manage-data/images/elasticsearch-reference-lifecycle-disabled.png)
  </tab-item>

  <tab-item title="API">
    To remove a data stream's lifecycle:
    ```json
    ```
    After running the API request, the maintenance operations that were applied by the lifecycle will no longer be applied to the data stream and all of its backing indices.You can then use the [explain API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-explain-data-lifecycle) again to see that the indices are no longer managed.
    ```json
    ```

    ```json
    {
      "indices": {
        ".ds-my-data-stream-2023.04.19-000002": {
          "index": ".ds-my-data-stream-2023.04.19-000002",  
          "managed_by_lifecycle": false                           
        },
        ".ds-my-data-stream-2023.04.17-000001": {
          "index": ".ds-my-data-stream-2023.04.19-000001",  
          "managed_by_lifecycle": false                           
        }
      }
    }
    ```
  </tab-item>
</tab-set>


## Manage data retention on the Streams page

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.2
  - Elastic Stack: Preview in 9.1
</applies-to>

Starting with Elastic Stack version 9.2, the **Streams** page provides a centralized interface for common data management tasks in Kibana, including getting insight into how your data streams retain data.
1. Go to the **Streams** page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Each stream maps directly to an Elasticsearch data stream. Select a stream to view its details.
3. Go to the **Retention** tab to set how long your stream retains data and to get insight into your stream's data ingestion and storage size.
4. Select **Edit data retention** and choose to retain your data indefinitely, for a custom period, or by following an existing ILM policy. You can also use the data retention configuration that's set in the index template by enabling the  **Inherit from index template** option. If you use this option, you don't need to specify a custom retention period or policy.

For more information about the retention configuration options, refer to [Manage data retention for Streams](https://www.elastic.co/docs/solutions/observability/streams/management/retention).