﻿---
title: Creating a data stream with a lifecycle
description: Follow these steps to create an Elasticsearch data stream with a configured lifecycle. Learn how to set the retention period for your data and to retrieve...
url: https://www.elastic.co/docs/manage-data/lifecycle/data-stream/tutorial-create-data-stream-with-lifecycle
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Creating a data stream with a lifecycle
Follow these steps to create an Elasticsearch data stream with a configured lifecycle. Learn how to set the retention period for your data and to retrieve the lifecycle configuration details.
1. [Create an index template](#create-index-template-with-lifecycle)
2. [Create a data stream](#create-data-stream-with-lifecycle)
3. [Retrieve lifecycle information](#retrieve-lifecycle-information)


## Create an index template

A data stream requires a matching [index template](https://www.elastic.co/docs/manage-data/data-store/templates). You can configure the data stream lifecycle by setting the `lifecycle` field in the index template the same as you do for mappings and index settings. You can define an index template that sets a lifecycle as follows:
- Include the `data_stream` object to enable data streams.
- Define the lifecycle in the template section or include a composable template that defines the lifecycle.
- Use a priority higher than `200` to avoid collisions with built-in templates. See [Avoid index pattern collisions](/docs/manage-data/data-store/templates#avoid-index-pattern-collisions).

You can use the [create index template API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-index-template).
```json

{
  "index_patterns": ["my-data-stream-test"], <1>
  "data_stream": { },
  "priority": 500,
  "template": {
    "lifecycle": {
      "data_retention": "7d"
    }
  },
  "_meta": {
    "description": "Template with data stream lifecycle"
  }
}
```


## Create a data stream

You can create a data stream in these ways:
- By manually creating the stream using the [create data stream API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create-data-stream). The stream’s name must still match one of your template’s index patterns.
  ```json
  ```
- By [indexing requests](/docs/manage-data/data-store/data-streams/use-data-stream#add-documents-to-a-data-stream) that target the stream’s name. This name must match one of your index template’s index patterns.
  ```json

  { "create":{ } }
  { "@timestamp": "2099-05-06T16:21:15.000Z", "message": "192.0.2.42 - - [06/May/2099:16:21:15 +0000] \"GET /images/bg.jpg HTTP/1.0\" 200 24736" }
  { "create":{ } }
  { "@timestamp": "2099-05-06T16:25:42.000Z", "message": "192.0.2.255 - - [06/May/2099:16:25:42 +0000] \"GET /favicon.ico HTTP/1.0\" 200 3638" }
  ```
- <applies-to>Elastic Stack: Generally available since 9.3</applies-to> You can create a classic stream directly in the [**Streams**](https://www.elastic.co/docs/solutions/observability/streams/streams) UI in Kibana.
  1. Go to the **Streams** page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. From the upper right, select **Create classic stream**.
3. Select the index template you want to use, name your stream, and select **Create**.


## Retrieve lifecycle information

You can use the [get data stream lifecycle API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-get-data-lifecycle) to see the data stream lifecycle of your data stream and the [explain data stream lifecycle API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-explain-data-lifecycle) to see the exact state of each backing index.
```json
```

The result will look like this:
```json
{
  "data_streams": [
    {
      "name": "my-data-stream-test",                                
      "lifecycle": {
        "enabled": true,                                            
        "data_retention": "7d",                                     
        "effective_retention": "7d",                                
        "retention_determined_by": "data_stream_configuration"
      }
    }
  ],
  "global_retention": {}
}
```

If you want to see more information about how the data stream lifecycle is applied on individual backing indices use the [explain data stream lifecycle API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-explain-data-lifecycle):
```json
```

<tip>
  You can use a wildcard (`*`) in the data stream name to retrieve the lifecycle status for all data streams matching the pattern.
</tip>

The result will look like this:
```json
{
  "indices": {
    ".ds-my-data-stream-test-2023.04.19-000001": {
      "index": ".ds-my-data-stream-test-2023.04.19-000001",      
      "managed_by_lifecycle": true,                               
      "index_creation_date_millis": 1681918009501,
      "time_since_index_creation": "1.6m",                  
      "lifecycle": {                                        
        "enabled": true,
        "data_retention": "7d"
      }
    }
  }
}
```