﻿---
title: Logstash pipelines
description: This content applies to: Elasticsearch Observability Security On the Logstash Pipelines management page, you can control multiple Logstash instances and...
url: https://www.elastic.co/docs/manage-data/ingest/transform-enrich/logstash-pipelines
products:
  - Elastic Cloud Serverless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Logstash pipelines
This content applies to: [![Elasticsearch](https://www.elastic.co/docs/manage-data/images/serverless-es-badge.svg)](https://www.elastic.co/docs/solutions/search) [![Observability](https://www.elastic.co/docs/manage-data/images/serverless-obs-badge.svg)](https://www.elastic.co/docs/solutions/observability) [![Security](https://www.elastic.co/docs/manage-data/images/serverless-sec-badge.svg)](https://www.elastic.co/docs/solutions/security)
On the **Logstash Pipelines** management page, you can control multiple Logstash instances and pipeline configurations.
![Logstash Pipelines"](https://www.elastic.co/docs/manage-data/images/serverless-logstash-pipelines-management.png)

On the Logstash side, you must enable configuration management and register Logstash to use the centrally managed pipeline configurations.
<important>
  After you configure Logstash to use centralized pipeline management, you can no longer specify local pipeline configurations. The `pipelines.yml` file and settings such as `path.config` and `config.string` are inactive when centralized pipeline management is enabled.
</important>


## Manage pipelines

1. [Configure centralized pipeline management](https://www.elastic.co/docs/reference/logstash/configuring-centralized-pipelines).
2. To add a new pipeline, go to the **Logstash Pipelines** management page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
3. Click **Create pipeline**.
4. Provide the following details, then click **Create and deploy**.
   <definitions>
   <definition term="Pipeline ID">
   A name that uniquely identifies the pipeline. This is the ID that you used when you configured centralized pipeline management and specified a list of pipeline IDs in the `xpack.management.pipeline.id` setting.
   </definition>
   <definition term="Description">
   A description of the pipeline configuration. This information is for your use.
   </definition>
   <definition term="Pipeline">
   The pipeline configuration. You can treat the editor like any other editor. You don’t have to worry about whitespace or indentation.
   </definition>
   <definition term="Pipeline workers">
   The number of parallel workers used to run the filter and output stages of the pipeline.
   </definition>
   <definition term="Pipeline batch size">
   The maximum number of events an individual worker thread collects before executing filters and outputs.
   </definition>
   <definition term="Pipeline batch delay">
   Time in milliseconds to wait for each event before sending an undersized batch to pipeline workers.
   </definition>
   <definition term="Queue type">
   The internal queueing model for event buffering. Options are `memory` for in-memory queueing and `persisted` for disk-based acknowledged queueing.
   </definition>
   <definition term="Queue max bytes">
   The total capacity of the queue when persistent queues are enabled.
   </definition>
   <definition term="Queue checkpoint writes">
   The maximum number of events written before a checkpoint is forced when persistent queues are enabled.
   </definition>
   </definitions>

To delete one or more pipelines, select their checkboxes then click **Delete**.
For more information about pipeline behavior, go to [Centralized Pipeline Management](https://www.elastic.co/docs/reference/logstash/logstash-centralized-pipeline-management#_pipeline_behavior).