﻿---
title: Example: Enrich your data by matching a value to a range
description: A range enrich policy uses a term query to match a number, date, or IP address in incoming documents to a range of the same type in the enrich index...
url: https://www.elastic.co/docs/manage-data/ingest/transform-enrich/example-enrich-data-by-matching-value-to-range
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Example: Enrich your data by matching a value to a range
A `range` [enrich policy](/docs/manage-data/ingest/transform-enrich/data-enrichment#enrich-policy) uses a [`term` query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-term-query) to match a number, date, or IP address in incoming documents to a range of the same type in the enrich index. Matching a range to a range is not supported.
The following example creates a `range` enrich policy that adds a descriptive network name and responsible department to incoming documents based on an IP address. It then adds the enrich policy to a processor in an ingest pipeline.
Use the [create index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) with the appropriate mappings to create a source index.
```json

{
  "mappings": {
    "properties": {
      "range": { "type": "ip_range" },
      "name": { "type": "keyword" },
      "department": { "type": "keyword" }
    }
  }
}
```

The following index API request indexes a new document to that index.
```json

{
  "range": "10.100.0.0/16",
  "name": "production",
  "department": "OPS"
}
```

Use the create enrich policy API to create an enrich policy with the `range` policy type. This policy must include:
- One or more source indices
- A `match_field`, the field from the source indices used to match incoming documents
- Enrich fields from the source indices you’d like to append to incoming documents

Since we plan to enrich documents based on an IP address, the policy’s `match_field` must be an `ip_range` field.
```json

{
  "range": {
    "indices": "networks",
    "match_field": "range",
    "enrich_fields": ["name", "department"]
  }
}
```

Use the [execute enrich policy API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-enrich-execute-policy) to create an enrich index for the policy.
```json
```

Use the [create or update pipeline API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ingest-put-pipeline) to create an ingest pipeline. In the pipeline, add an [enrich processor](https://www.elastic.co/docs/reference/enrich-processor/enrich-processor) that includes:
- Your enrich policy.
- The `field` of incoming documents used to match documents from the enrich index.
- The `target_field` used to store appended enrich data for incoming documents. This field contains the `match_field` and `enrich_fields` specified in your enrich policy.

```json

{
  "processors" : [
    {
      "enrich" : {
        "description": "Add 'network' data based on 'ip'",
        "policy_name": "networks-policy",
        "field" : "ip",
        "target_field": "network",
        "max_matches": "10"
      }
    }
  ]
}
```

Use the ingest pipeline to index a document. The incoming document should include the `field` specified in your enrich processor.
```json

{
  "ip": "10.100.34.1"
}
```

To verify the enrich processor matched and appended the appropriate field data, use the [get API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-get) to view the indexed document.
```json
```

The API returns the following response:
```json
{
  "_index" : "my-index-000001",
  "_id" : "my_id",
  "_version" : 1,
  "_seq_no" : 0,
  "_primary_term" : 1,
  "found" : true,
  "_source" : {
    "ip" : "10.100.34.1",
    "network" : [
      {
        "name" : "production",
        "range" : "10.100.0.0/16",
        "department" : "OPS"
      }
    ]
  }
}
```