﻿---
title: Example: Enrich your data based on geolocation
description: geo_match enrich policies match enrich data to incoming documents based on a geographic location, using a geo_shape query. The following example creates...
url: https://www.elastic.co/docs/manage-data/ingest/transform-enrich/example-enrich-data-based-on-geolocation
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Example: Enrich your data based on geolocation
`geo_match` [enrich policies](/docs/manage-data/ingest/transform-enrich/data-enrichment#enrich-policy) match enrich data to incoming documents based on a geographic location, using a [`geo_shape` query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-geo-shape-query).
The following example creates a `geo_match` enrich policy that adds postal codes to incoming documents based on a set of coordinates. It then adds the `geo_match` enrich policy to a processor in an ingest pipeline.
Use the [create index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) to create a source index containing at least one `geo_shape` field.
```json

{
  "mappings": {
    "properties": {
      "location": {
        "type": "geo_shape"
      },
      "postal_code": {
        "type": "keyword"
      }
    }
  }
}
```

Use the [index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-create) to index enrich data to this source index.
```json

{
  "location": {
    "type": "envelope",
    "coordinates": [ [ 13.0, 53.0 ], [ 14.0, 52.0 ] ]
  },
  "postal_code": "96598"
}
```

Use the [create enrich policy API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-enrich-put-policy) to create an enrich policy with the `geo_match` policy type. This policy must include:
- One or more source indices
- A `match_field`, the `geo_shape` field from the source indices used to match incoming documents
- Enrich fields from the source indices you’d like to append to incoming documents

```json

{
  "geo_match": {
    "indices": "postal_codes",
    "match_field": "location",
    "enrich_fields": [ "location", "postal_code" ]
  }
}
```

Use the [execute enrich policy API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-enrich-execute-policy) to create an enrich index for the policy.
```json
```

Use the [create or update pipeline API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ingest-put-pipeline) to create an ingest pipeline. In the pipeline, add an [enrich processor](https://www.elastic.co/docs/reference/enrich-processor/enrich-processor) that includes:
- Your enrich policy.
- The `field` of incoming documents used to match the geoshape of documents from the enrich index.
- The `target_field` used to store appended enrich data for incoming documents. This field contains the `match_field` and `enrich_fields` specified in your enrich policy.
- The `shape_relation`, which indicates how the processor matches geoshapes in incoming documents to geoshapes in documents from the enrich index. See [Spatial Relations](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-shape-query#_spatial_relations) for valid options and more information.

```json

{
  "processors": [
    {
      "enrich": {
        "description": "Add 'geo_data' based on 'geo_location'",
        "policy_name": "postal_policy",
        "field": "geo_location",
        "target_field": "geo_data",
        "shape_relation": "INTERSECTS"
      }
    }
  ]
}
```

Use the ingest pipeline to index a document. The incoming document should include the `field` specified in your enrich processor.
```json

{
  "first_name": "Mardy",
  "last_name": "Brown",
  "geo_location": "POINT (13.5 52.5)"
}
```

To verify the enrich processor matched and appended the appropriate field data, use the [get API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-get) to view the indexed document.
```json
```

The API returns the following response:
```json
{
  "found": true,
  "_index": "users",
  "_id": "0",
  "_version": 1,
  "_seq_no": 55,
  "_primary_term": 1,
  "_source": {
    "geo_data": {
      "location": {
        "type": "envelope",
        "coordinates": [[13.0, 53.0], [14.0, 52.0]]
      },
      "postal_code": "96598"
    },
    "first_name": "Mardy",
    "last_name": "Brown",
    "geo_location": "POINT (13.5 52.5)"
  }
}
```