﻿---
title: Example: Enrich your data based on exact values
description: match enrich policies match enrich data to incoming documents based on an exact value, such as a email address or ID, using a term query. The following...
url: https://www.elastic.co/docs/manage-data/ingest/transform-enrich/example-enrich-data-based-on-exact-values
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Example: Enrich your data based on exact values
`match` [enrich policies](/docs/manage-data/ingest/transform-enrich/data-enrichment#enrich-policy) match enrich data to incoming documents based on an exact value, such as a email address or ID, using a [`term` query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-term-query).
The following example creates a `match` enrich policy that adds user name and contact information to incoming documents based on an email address. It then adds the `match` enrich policy to a processor in an ingest pipeline.
Use the [create index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) or [index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-create) to create a source index.
The following index API request creates a source index and indexes a new document to that index.
```json

{
  "email": "mardy.brown@example.com",
  "first_name": "Mardy",
  "last_name": "Brown",
  "city": "New Orleans",
  "county": "Orleans",
  "state": "LA",
  "zip": 70116,
  "web": "mardy.example.com"
}
```

Use the create enrich policy API to create an enrich policy with the `match` policy type. This policy must include:
- One or more source indices
- A `match_field`, the field from the source indices used to match incoming documents
- Enrich fields from the source indices you’d like to append to incoming documents

```json

{
  "match": {
    "indices": "users",
    "match_field": "email",
    "enrich_fields": ["first_name", "last_name", "city", "zip", "state"]
  }
}
```

Use the [execute enrich policy API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-enrich-execute-policy) to create an enrich index for the policy.
```json
```

Use the [create or update pipeline API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ingest-put-pipeline) to create an ingest pipeline. In the pipeline, add an [enrich processor](https://www.elastic.co/docs/reference/enrich-processor/enrich-processor) that includes:
- Your enrich policy.
- The `field` of incoming documents used to match documents from the enrich index.
- The `target_field` used to store appended enrich data for incoming documents. This field contains the `match_field` and `enrich_fields` specified in your enrich policy.

```json

{
  "processors" : [
    {
      "enrich" : {
        "description": "Add 'user' data based on 'email'",
        "policy_name": "users-policy",
        "field" : "email",
        "target_field": "user",
        "max_matches": "1"
      }
    }
  ]
}
```

Use the ingest pipeline to index a document. The incoming document should include the `field` specified in your enrich processor.
```json

{
  "email": "mardy.brown@example.com"
}
```

To verify the enrich processor matched and appended the appropriate field data, use the [get API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-get) to view the indexed document.
```json
```

The API returns the following response:
```json
{
  "found": true,
  "_index": "my-index-000001",
  "_id": "my_id",
  "_version": 1,
  "_seq_no": 55,
  "_primary_term": 1,
  "_source": {
    "user": {
      "email": "mardy.brown@example.com",
      "first_name": "Mardy",
      "last_name": "Brown",
      "zip": 70116,
      "city": "New Orleans",
      "state": "LA"
    },
    "email": "mardy.brown@example.com"
  }
}
```