﻿---
title: Ingest tools overview
description: Depending on the type of data you want to ingest, you have a number of methods and tools available for use in your ingestion process. The table below...
url: https://www.elastic.co/docs/manage-data/ingest/tools
products:
  - Elastic Cloud Hosted
  - Elastic Cloud Serverless
  - Fleet
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Ingest tools overview
Depending on the type of data you want to ingest, you have a number of methods and tools available for use in your ingestion process. The table below provides more information about the available tools.
Refer to our [Ingestion](https://www.elastic.co/docs/manage-data/ingest) overview for some guidelines to help you select the optimal tool for your use case.


| Tools                                | Usage                                                                                                                                                                                                                                                                                         | Links to more information                                                                                                                                                                                                                                                                                                         |
|--------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Integrations                         | Ingest data using a variety of Elastic integrations.                                                                                                                                                                                                                                          | [Elastic Integrations](https://www.elastic.co/docs/reference/integrations)                                                                                                                                                                                                                                                        |
| File upload                          | Upload data from a file and inspect it before importing it into Elasticsearch.                                                                                                                                                                                                                | [Upload data files](https://www.elastic.co/docs/manage-data/ingest/upload-data-files)                                                                                                                                                                                                                                             |
| APIs                                 | Ingest data through code by using the APIs of one of the language clients or the Elasticsearch HTTP APIs.                                                                                                                                                                                     | [Document APIs](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-document)                                                                                                                                                                                                                                        |
| OpenTelemetry                        | Collect and send your telemetry data to Elastic Observability                                                                                                                                                                                                                                 | [Elastic Distributions of OpenTelemetry](https://www.elastic.co/docs/reference/opentelemetry)                                                                                                                                                                                                                                     |
| Fleet and Elastic Agent              | Add monitoring for logs, metrics, and other types of data to a host using Elastic Agent, and centrally manage it using Fleet.                                                                                                                                                                 | [Fleet and Elastic Agent overview](https://www.elastic.co/docs/reference/fleet)  [Fleet and Elastic Agent restrictions (Serverless)](https://www.elastic.co/docs/reference/fleet/fleet-agent-serverless-restrictions)  [Beats and Elastic Agent capabilities](https://www.elastic.co/docs/reference/fleet/beats-agent-comparison) |
| Elastic Defend                       | Elastic Defend provides organizations with prevention, detection, and response capabilities with deep visibility for EPP, EDR, SIEM, and Security Analytics use cases across Windows, macOS, and Linux operating systems running on both traditional endpoints and public cloud environments. | [Configure endpoint protection with Elastic Defend](https://www.elastic.co/docs/solutions/security/configure-elastic-defend)                                                                                                                                                                                                      |
| Logstash                             | Dynamically unify data from a wide variety of data sources and normalize it into destinations of your choice with Logstash.                                                                                                                                                                   | [Logstash](https://www.elastic.co/docs/reference/logstash)                                                                                                                                                                                                                                                                        |
| Beats                                | Use Beats data shippers to send operational data to Elasticsearch directly or through Logstash.                                                                                                                                                                                               | [Beats](https://www.elastic.co/docs/reference/beats)                                                                                                                                                                                                                                                                              |
| APM                                  | Collect detailed performance information on response time for incoming requests, database queries, calls to caches, external HTTP requests, and more.                                                                                                                                         | [Application performance monitoring (APM)](https://www.elastic.co/docs/solutions/observability/apm)                                                                                                                                                                                                                               |
| Application logs                     | Ingest application logs using Filebeat, Elastic Agent, or the APM agent, or reformat application logs into Elastic Common Schema (ECS) logs and then ingest them using Filebeat or Elastic Agent.                                                                                             | [Stream application logs](https://www.elastic.co/docs/solutions/observability/logs/stream-application-logs)  [ECS formatted application logs](https://www.elastic.co/docs/solutions/observability/logs/ecs-formatted-application-logs)                                                                                            |
| Elastic Serverless forwarder for AWS | Ship logs from your AWS environment to cloud-hosted, self-managed Elastic environments, or Logstash.                                                                                                                                                                                          | [Elastic Serverless Forwarder](https://www.elastic.co/docs/reference/aws-forwarder)                                                                                                                                                                                                                                               |
| Connectors                           | Use connectors to extract data from an original data source and sync it to an Elasticsearch index.                                                                                                                                                                                            | [Ingest content with Elastic connectors](https://www.elastic.co/docs/reference/search-connectors)  [Connector clients](https://www.elastic.co/docs/reference/search-connectors)                                                                                                                                                   |
| Web crawler                          | Discover, extract, and index searchable content from websites and knowledge bases using the web crawler.                                                                                                                                                                                      | [Elastic Open Web Crawler](https://github.com/elastic/crawler#readme)                                                                                                                                                                                                                                                             |