﻿---
title: Sample data
description: Using sample data is a great way to start exploring the system and learn your way around. There are a few ways to easily ingest sample data into Elasticsearch...
url: https://www.elastic.co/docs/manage-data/ingest/sample-data
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Sample data
Using sample data is a great way to start exploring the system and learn your way around. There are a few ways to easily ingest sample data into Elasticsearch.

## Add sample data sets

The simplest way is to add one or more of our sample data sets. These data sets come with sample visualizations, dashboards, and more to help you explore the interface before you add your own data.
If you have no data, you will be prompted to install these packages when running Kibana for the first time.
You can also access and install them from the **Integrations** page. Go to **Integrations** and search for **Sample data**. On the **Sample data** page, expand the **Other sample data sets** section and add the type of data you want.
![Sample data sets](https://www.elastic.co/docs/manage-data/images/sample-data-sets.png)


## Run the makelogs script

Alternatively, run the provided `makelogs` script to generate sample data.
```bash
node scripts/makelogs --auth <username>:<password>
```

The default username and password combination are `elastic:changeme`
<important>
  Make sure to execute `node scripts/makelogs` *after* Elasticsearch is up and running.
</important>


## Upload a file

You can also upload your own sample data using the **Upload a file** option on the **Integrations** page. For detailed instructions, refer to [Upload data files](https://www.elastic.co/docs/manage-data/ingest/upload-data-files).