﻿---
title: Ingesting time series data
description: Elastic and others offer tools to help you get your data from the original data source into Elasticsearch. Some tools are designed for particular data...
url: https://www.elastic.co/docs/manage-data/ingest/ingesting-timeseries-data
products:
  - Elastic Stack
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Ingesting time series data
Elastic and others offer tools to help you get your data from the original data source into Elasticsearch. Some tools are designed for particular data sources, and others are multi-purpose.
In this section, we’ll help you determine which option is best for you.
- [Elastic Agent and Elastic integrations](#ingest-ea)
- [Beats](#ingest-beats)
- [OpenTelemetry (OTel) collectors](#ingest-otel)
- [Logstash](#ingest-logstash)


## Elastic Agent and Elastic integrations

A single [Elastic Agent](https://www.elastic.co/docs/reference/fleet) can collect multiple types of data when it is [installed](https://www.elastic.co/docs/reference/fleet/install-elastic-agents) on a host computer. You can use standalone Elastic Agents and manage them locally on the systems where they are installed, or you can manage all of your agents and policies with the [Fleet UI in Kibana](https://www.elastic.co/docs/reference/fleet/manage-elastic-agents-in-fleet).
Use Elastic Agent with one of hundreds of [Elastic integrations](https://docs.elastic.co/en/integrations) to simplify collecting, transforming, and visualizing data. Integrations include default ingestion rules, dashboards, and visualizations to help you start analyzing your data right away. Check out the [Integration quick reference](https://docs.elastic.co/en/integrations/all_integrations) to search for available integrations that can reduce your time to value.
Elastic Agent is the best option for collecting timestamped data for most data sources and use cases. If your data requires additional processing before going to Elasticsearch, you can use [Elastic Agent processors](https://www.elastic.co/docs/reference/fleet/agent-processors), [Logstash](https://www.elastic.co/docs/reference/logstash), or additional processing features in Elasticsearch. Check out [additional processing](https://www.elastic.co/docs/manage-data/ingest/transform-enrich) to see options.
Ready to try [Elastic Agent](https://www.elastic.co/docs/reference/fleet)? Check out the [installation instructions](https://www.elastic.co/docs/reference/fleet/install-elastic-agents).

## Beats

[Beats](https://www.elastic.co/docs/reference/beats) open source data shippers that you install as agents on your servers to send operational data to Elasticsearch. Elastic provides separate Beats for different types of data, such as logs, metrics, and uptime.
Beats has been replaced by Elastic Agent for most use cases. When you use Elastic Agent, you’re getting core Beats functionality, but with more added features. Where you might need to install multiple Beats shippers on a host depending on your data requirements, single Elastic Agent installed on a host can collect and transport multiple types of data.
**Best practice:** Use [Elastic Agent](https://www.elastic.co/docs/reference/fleet) whenever possible. If your data source is not yet supported by Elastic Agent, use Beats. Check out the Beats and Elastic Agent [comparison](https://www.elastic.co/docs/reference/fleet/beats-agent-comparison) for more info. When you are ready to upgrade, check out [Migrate from Beats to Elastic Agent](https://www.elastic.co/docs/reference/fleet/migrate-from-beats-to-elastic-agent).

## OpenTelemetry (OTel) collectors

[OpenTelemetry](https://opentelemetry.io/docs) is a vendor-neutral observability framework for collecting, processing, and exporting telemetry data. Elastic is a member of the Cloud Native Computing Foundation (CNCF) and active contributor to the OpenTelemetry project.
In addition to supporting upstream OTel development, Elastic provides [Elastic Distributions of OpenTelemetry](https://www.elastic.co/docs/reference/opentelemetry), specifically designed to work with Elastic Observability.
We’re also expanding [Elastic Agent](https://www.elastic.co/docs/reference/fleet) to use OTel collection.

## Logstash

[Logstash](https://www.elastic.co/docs/reference/logstash) is a versatile open source data ETL (extract, transform, load) engine that can expand your ingest capabilities. Logstash can *collect data* from a wide variety of data sources with Logstash [input plugins](https://www.elastic.co/docs/reference/logstash/plugins/input-plugins), *enrich and transform* the data with Logstash [filter plugins](https://www.elastic.co/docs/reference/logstash/plugins/filter-plugins), and *output* the data to Elasticsearch and other destinations with the Logstash [output plugins](https://www.elastic.co/docs/reference/logstash/plugins/output-plugins).
Many users never need to use Logstash, but it’s available if you need it for:
- **Data collection** (if an Elastic integration isn’t available). Elastic Agent and Elastic [integrations](https://docs.elastic.co/en/integrations/all_integrations) provide many features out-of-the-box, so be sure to search or browse integrations for your data source. If you don’t find an Elastic integration for your data source, check Logstash for an [input plugin](https://www.elastic.co/docs/reference/logstash/plugins/input-plugins) for your data source.
- **Additional processing.** One of the most common Logstash use cases is [extending Elastic integrations](https://www.elastic.co/docs/reference/logstash/using-logstash-with-elastic-integrations). You can take advantage of the extensive, built-in capabilities of Elastic Agent and Elastic Integrations, and then use Logstash for additional data processing before sending the data on to Elasticsearch.
- **Advanced use cases.** Logstash can help with advanced use cases, such as when you need [persistence or buffering](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/lspq), additional [data enrichment](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/ls-enrich), [proxying](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/ls-networkbridge) as a way to bridge network connections, or the ability to route data to [multiple destinations](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/ls-multi).