﻿---
title: Ingesting data from applications
description: The following tutorials demonstrate how you can use the Elasticsearch language clients to ingest data from an application into a deployment in Elastic...
url: https://www.elastic.co/docs/manage-data/ingest/ingesting-data-from-applications
products:
  - Elastic Cloud Enterprise
  - Elastic Cloud Hosted
applies_to:
  - Elastic Stack: Generally available
---

# Ingesting data from applications
The following tutorials demonstrate how you can use the Elasticsearch language clients to ingest data from an application into a deployment in Elastic Cloud Hosted or Elastic Cloud Enterprise.
<definitions>
  <definition term="Ingest data with Node.js">
    Get Node.js application data securely into your Elastic Cloud Hosted or Elastic Cloud Enterprise deployment, where it can then be searched and modified.
  </definition>
  <definition term="Ingest data with Python">
    Get Python application data securely into your Elastic Cloud Hosted or Elastic Cloud Enterprise deployment, where it can then be searched and modified.
  </definition>
  <definition term="Ingest data from Beats with Logstash as a proxy">
    Get server metrics or other types of data from Filebeat and Metricbeat into Logstash as an intermediary, and then send that data to your Elastic Cloud Hosted or Elastic Cloud Enterprise deployment. Using Logstash as a proxy limits your Elastic Stack traffic through a single, external-facing firewall exception or rule.
  </definition>
  <definition term="Ingest data from a relational database">
    Get data from a relational database into your Elastic Cloud Hosted or Elastic Cloud Enterprise deployment using the Logstash JDBC input plugin. Logstash can be used as an efficient way to copy records and to receive updates from a relational database as changes happen, and then send the new data to a deployment.
  </definition>
  <definition term="Ingest logs from a Python application using Filebeat">
    Get logs from a Python application and deliver them securely into your Elastic Cloud Hosted or Elastic Cloud Enterprise deployment. You’ll set up Filebeat to monitor an ECS-formatted log file, and then view real-time visualizations of the log events in Kibana as they occur.
  </definition>
  <definition term="Ingest logs from a Node.js web application using Filebeat">
    Get HTTP request logs from a Node.js web application and deliver them securely into your Elastic Cloud Hosted or Elastic Cloud Enterprise deployment. You’ll set up Filebeat to monitor an ECS-formatted log file and then view real-time visualizations of the log events as HTTP requests occur on your Node.js web server.
  </definition>
</definitions>

<tip>
  You can use [Elasticsearch ingest pipelines](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/ingest-pipelines) to preprocess incoming data. This enables you to optimize how your data is indexed, and simplifies tasks such as extracting error codes from a log file and mapping geographic locations to IP addresses.
</tip>