﻿---
title: Ingesting data for Elastic solutions
description: Elastic solutions—Security, Observability, and Search—are loaded with features and functionality to help you get value and insights from your data. Elastic...
url: https://www.elastic.co/docs/manage-data/ingest/ingesting-data-for-elastic-solutions
products:
  - Elastic Stack
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Ingesting data for Elastic solutions
Elastic solutions—Security, Observability, and Search—are loaded with features and functionality to help you get value and insights from your data. [Elastic Agent](https://www.elastic.co/docs/reference/fleet) and [Elastic integrations](https://docs.elastic.co/en/integrations) can help, and are the best place to start.
When you use integrations with solutions, you have an integrated experience that offers easier implementation and decreases the time it takes to get insights and value from your data.
<admonition title="High-level overview">
  To use [Elastic Agent](https://www.elastic.co/docs/reference/fleet) and [Elastic integrations](https://docs.elastic.co/en/integrations) with Elastic solutions:
  1. Create an [Elastic Cloud](https://www.elastic.co/cloud) deployment for your solution. If you don’t have an Elastic Cloud account, you can sign up for a [free trial](https://cloud.elastic.co/registration) to get started.
  2. Add the [Elastic integration](https://docs.elastic.co/en/integrations) for your data source to the deployment.
  3. [Install Elastic Agent](https://www.elastic.co/docs/reference/fleet/install-elastic-agents) on the systems whose data you want to collect.
</admonition>

<note>
  [Elastic serverless](https://docs.elastic.co/serverless) makes using solutions even easier. Sign up for a [free trial](https://docs.elastic.co/serverless/general/sign-up-trial), and check it out.
</note>


## Ingesting data for Search

Elasticsearch is the magic behind Search and our other solutions. The solution gives you more pre-built components to get you up and running quickly for common use cases.
**Resources**
- [Install Elastic Agent](https://www.elastic.co/docs/reference/fleet/install-elastic-agents)
- [Elastic Search for integrations](https://www.elastic.co/integrations/data-integrations?solution=search)
- [Elasticsearch Guide](https://www.elastic.co/docs/reference)
  - [Elasticsearch document APIs](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-document)
- [Elasticsearch language clients](https://www.elastic.co/docs/reference/elasticsearch-clients)
- [Elastic web crawler](https://www.elastic.co/web-crawler)
- [Elastic connectors](https://www.elastic.co/docs/reference/search-connectors)


## Ingesting data for Observability

With [Elastic Observability](https://www.elastic.co/observability), you can monitor and gain insights into logs, metrics, and application traces. The guides and resources in this section illustrate how to ingest data and use it with the Observability solution.
**Guides for popular Observability use cases**
- [Monitor applications and systems with Elastic Observability](https://www.elastic.co/docs/solutions/observability/get-started/quickstart-monitor-hosts-with-elastic-agent)
- [Get started with logs and metrics](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/get-started-with-system-metrics)
  - [Step 1: Add the Elastic Agent System integration](/docs/solutions/observability/infra-and-hosts/get-started-with-system-metrics#add-system-integration)
- [Step 2: Install and run Elastic Agent](/docs/solutions/observability/infra-and-hosts/get-started-with-system-metrics#add-agent-to-fleet)
- [Observability](https://docs.elastic.co/serverless/observability/what-is-observability-serverless) on [Elastic Cloud Serverless](https://docs.elastic.co/serverless):
  - [Monitor hosts with Elastic Agent (Serverless)](https://docs.elastic.co/serverless/observability/quickstarts/monitor-hosts-with-elastic-agent)
- [Monitor your K8s cluster with Elastic Agent (Serverless)](https://docs.elastic.co/serverless/observability/quickstarts/k8s-logs-metrics)
- [Use OpenTelemetry with APM](https://www.elastic.co/docs/solutions/observability/apm/opentelemetry)

**Resources**
- [Install Elastic Agent](https://www.elastic.co/docs/reference/fleet/install-elastic-agents)
- [Elastic Observability integrations](https://www.elastic.co/integrations/data-integrations?solution=observability)


## Ingesting data for Security

You can detect and respond to threats when you use [Elastic Security](https://www.elastic.co/security) to analyze and take action on your data. The guides and resources in this section illustrate how to ingest data and use it with the Security solution.
**Guides for popular Security use cases**
- [Use Elastic Security for SIEM](https://www.elastic.co/getting-started/security/detect-threats-in-my-data-with-siem)
- [Protect hosts with endpoint threat intelligence from Elastic Security](https://www.elastic.co/getting-started/security/secure-my-hosts-with-endpoint-security)

**Resources**
- [Install Elastic Agent](https://www.elastic.co/docs/reference/fleet/install-elastic-agents)
- [Elastic Security integrations](https://www.elastic.co/integrations/data-integrations?solution=search)
- [Elastic Security documentation](https://www.elastic.co/docs/solutions/security)


## Ingesting data for your own custom search solution

Elastic solutions can give you a head start for common use cases, but you are not at all limited. You can still do your own thing with a custom solution designed by *you*.
Bring your ideas and use Elasticsearch and the Elastic Stack to store, search, and visualize your data.
**Resources**
- [Install Elastic Agent](https://www.elastic.co/docs/reference/fleet/install-elastic-agents)
- [Elasticsearch Guide](https://www.elastic.co/docs/reference)
  - [Elasticsearch document APIs](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-document)
- [Elasticsearch language clients](https://www.elastic.co/docs/reference/elasticsearch-clients)
- [Elastic web crawler](https://www.elastic.co/web-crawler)
- [Elastic connectors](https://www.elastic.co/docs/reference/search-connectors)