﻿---
title: Elastic Agent to Logstash to Elasticsearch: Logstash Persistent Queue (PQ) for buffering
description: Info on configuring Elastic Agent: Fleet and Elastic Agent Guide, Configuring outputs for Elastic Agent. For info on Logstash plugins: Elastic Agent input,...
url: https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/lspq
products:
  - Elastic Agent
  - Elastic Stack
  - Logstash
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Elastic Agent to Logstash to Elasticsearch: Logstash Persistent Queue (PQ) for buffering
![Image showing Elastic Agent collecting data](https://www.elastic.co/docs/manage-data/images/ingest-ea-lspq-es.png)

<definitions>
  <definition term="Ingest model">
    Elastic Agent to Logstash persistent queue to Elasticsearch
  </definition>
  <definition term="Use when">
    Your data flow may encounter network issues, bursts of events, or downstream unavailability, and you need the ability to buffer the data before ingestion.
  </definition>
</definitions>


## Resources

Info on configuring Elastic Agent:
- [Fleet and Elastic Agent Guide](https://www.elastic.co/docs/reference/fleet)
- [Configuring outputs for Elastic Agent](https://www.elastic.co/docs/reference/fleet/elastic-agent-output-configuration)

For info on Logstash plugins:
- [Elastic Agent input](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-elastic_agent)
- [Elasticsearch output plugin](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch)

For info on using Logstash for buffering and data resiliency, check out this section in the [Logstash Reference](https://www.elastic.co/docs/reference/logstash):
- [Logstash Persistent Queues (PQ)](https://www.elastic.co/docs/reference/logstash/persistent-queues)

Info on Elasticsearch:
- [Elasticsearch Guide](https://www.elastic.co/docs/reference)