﻿---
title: Elastic Agent to Logstash to Elasticsearch: Logstash as a proxy
description: Info on configuring Elastic Agent: Fleet and Elastic Agent Guide, Configuring outputs for Elastic Agent. Info on Logstash and Logstash plugins: Logstash...
url: https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/ls-networkbridge
products:
  - Elastic Agent
  - Elastic Stack
  - Logstash
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Elastic Agent to Logstash to Elasticsearch: Logstash as a proxy
![Image showing Elastic Agents collecting data and sending to Logstash for proxying before sending on to Elasticsearch](https://www.elastic.co/docs/manage-data/images/ingest-ea-ls-bridge.png)

<definitions>
  <definition term="Ingest model">
    Data path: Elastic Agent to Logstash as bridge to Elasticsearch on Elastic Stack network Control path: Elastic Agent to Fleet Server to Elasticsearch
  </definition>
  <definition term="Use when">
    Agents have network restrictions for connecting to Elasticsearch on Elastic Stack deployed outside of the agent network
  </definition>
  <definition term="Example">
    You can send data from multiple Elastic Agents through your demilitarized zone (DMZ) to Logstash, and then use Logstash as a proxy through your firewall to Elastic Cloud. This approach helps reduce the number of firewall exceptions needed to forward data from large numbers of Elastic Agents.
  </definition>
</definitions>


## Resources

Info on configuring Elastic Agent:
- [Fleet and Elastic Agent Guide](https://www.elastic.co/docs/reference/fleet)
- [Configuring outputs for Elastic Agent](https://www.elastic.co/docs/reference/fleet/elastic-agent-output-configuration)

Info on Logstash and Logstash plugins:
- [Logstash Reference](https://www.elastic.co/docs/reference/logstash)
- [Elasticsearch output plugin](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch)

Info on Elasticsearch:
- [Elasticsearch Guide](https://www.elastic.co/docs/reference)