﻿---
title: Elastic Agent to Logstash for routing to multiple Elasticsearch clusters and additional destinations
description: Info on configuring Elastic Agent: Fleet and Elastic Agent Guide, Configuring outputs for Elastic Agent. Info on Logstash and Logstash outputs: Logstash...
url: https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/ls-multi
products:
  - Elastic Agent
  - Elastic Stack
  - Logstash
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Elastic Agent to Logstash for routing to multiple Elasticsearch clusters and additional destinations
![Image showing Elastic Agent collecting and routing data to multiple destinations](https://www.elastic.co/docs/manage-data/images/ingest-ea-ls-multi.png)

<definitions>
  <definition term="Ingest model">
    Elastic Agent to Logstash to Elasticsearch clusters and additional destinations
  </definition>
  <definition term="Use when">
    Data collected by Elastic Agent needs to be routed to different Elasticsearch clusters or non-Elasticsearch destinations depending on the content
  </definition>
  <definition term="Example">
    Let’s take an example of a Windows workstation, for which we are collecting different types of logs using the System and Windows integrations. These logs need to be sent to different Elasticsearch clusters and to S3 for backup and a mechanism to send it to other destinations such as different SIEM solutions. In addition, the Elasticsearch destination is derived based on the type of data stream and an organization identifier.
    In such use cases, agents send the data to Logstash as a routing mechanism to different destinations. The System and Windows integrations must be installed on all Elasticsearch clusters to which the data is routed.
  </definition>
  <definition term="Sample config">
    ```ruby
    input {
    elastic_agent {
    port => 5044
    }
    }
    filter {
    translate {
    source => "[http][host]"
    target => "[@metadata][tenant]"
    dictionary_path => "/etc/conf.d/logstash/tenants.yml"
    }
    }
    output {
    if [@metadata][tenant] == "tenant01" {
    elasticsearch {
      cloud_id => "<cloud id>"
      api_key => "<api key>"
    }
    } else if [@metadata][tenant] == "tenant02" {
    elasticsearch {
      cloud_id => "<cloud id>"
      api_key => "<api key>"
    }
    }
    }
    ```
  </definition>
</definitions>


## Resources

Info on configuring Elastic Agent:
- [Fleet and Elastic Agent Guide](https://www.elastic.co/docs/reference/fleet)
- [Configuring outputs for Elastic Agent](https://www.elastic.co/docs/reference/fleet/elastic-agent-output-configuration)

Info on Logstash and Logstash outputs:
- [Logstash Reference](https://www.elastic.co/docs/reference/logstash)
- [Logstash Elasticsearch output plugin](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch)
- [Logstash output plugins](https://www.elastic.co/docs/reference/logstash/plugins/output-plugins)

Info on Elasticsearch:
- [Elasticsearch Guide](https://www.elastic.co/docs/reference)