﻿---
title: Logstash to Elasticsearch
description: Before you implement this approach, check to see if an Elastic Agent integration exists and, if so, use it instead: Elastic Agent integrations. Info on...
url: https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/ls-for-input
products:
  - Elastic Stack
  - Logstash
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Logstash to Elasticsearch
![Image showing Logstash collecting data and sending to Elasticsearch](https://www.elastic.co/docs/manage-data/images/ingest-ls-es.png)

<definitions>
  <definition term="Ingest model">
    Logstash to collect data from sources not currently supported by Elastic Agent and sending the data to Elasticsearch. The data transformation still happens within the Elasticsearch ingest pipeline.
  </definition>
  <definition term="Use when">
    Elastic Agent doesn’t currently support your data source.
  </definition>
  <definition term="Examples">
    AWS Kinesis, databases, Kafka
  </definition>
</definitions>


## Resources

Before you implement this approach, check to see if an Elastic Agent integration exists and, if so, use it instead:
- [Elastic Agent integrations](https://docs.elastic.co/en/integrations)

Info on Logstash and Logstash input and output plugins:
- [Logstash plugin support matrix](https://www.elastic.co/support/matrix#logstash_plugins)
- [Logstash Reference](https://www.elastic.co/docs/reference/logstash)
- [Logstash input plugins](https://www.elastic.co/docs/reference/logstash/plugins/input-plugins)
- [Elasticsearch output plugin](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch)

Info on Elasticsearch and ingest pipelines:
- [Elasticsearch Guide](https://www.elastic.co/docs/reference)
- [Elasticsearch Ingest Pipelines](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/ingest-pipelines)