﻿---
title: Elastic Agent to Logstash (for enrichment) to Elasticsearch
description: Info on configuring Elastic Agent: Fleet and Elastic Agent Guide, Configuring outputs for Elastic Agent. For info on Logstash for enriching data, check...
url: https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/ls-enrich
products:
  - Elastic Agent
  - Elastic Stack
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Elastic Agent to Logstash (for enrichment) to Elasticsearch
![Image showing Elastic Agent collecting data](https://www.elastic.co/docs/manage-data/images/ingest-ea-ls-enrich.png)

<definitions>
  <definition term="Ingest models">
    - Elastic Agent to Elasticsearch using Logstash to enrich the data
    - Elastic Agent to Logstash for enrichment based on fields in the Elastic Agent data to Elasticsearch
  </definition>
  <definition term="Use when">
    - Data enrichment in Elasticsearch is not practical for business or technical reasons
    - Your use case requires data enrichment based on fields in the Elastic Agent data. Logstash can collect enrichment data based on those fields, and then send the data to Elasticsearch.
  </definition>
  <definition term="Examples">
    - Data that changes frequently and is updated using an external source, such as stock ticker data
    - Enrichment data is proprietary and cannot be stored elsewhere.
    - Enrichment is done with an HTTP API whose return depends on values from the document. Example: An API that takes geo points with the collected data and returns available real estate in the region, and then passes to Logstash enrichment for enrichment between agents and Elasticsearch.
  </definition>
</definitions>


## Resources

Info on configuring Elastic Agent:
- [Fleet and Elastic Agent Guide](https://www.elastic.co/docs/reference/fleet)
- [Configuring outputs for Elastic Agent](https://www.elastic.co/docs/reference/fleet/elastic-agent-output-configuration)

For info on Logstash for enriching data, check out these sections in the [Logstash Reference](https://www.elastic.co/docs/reference/logstash):
- [Logstash Elastic Agent input](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-elastic_agent)
- [Logstash plugins for enriching data](https://www.elastic.co/docs/reference/logstash/lookup-enrichment)
- [Logstash filter plugins](https://www.elastic.co/docs/reference/logstash/plugins/filter-plugins)
- [Logstash Elasticsearch output](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch)

Info on Elasticsearch:
- [Elasticsearch Guide](https://www.elastic.co/docs/reference)