﻿---
title: Elastic Agent to Elasticsearch
description: To ingest data into Elasticsearch, use the simplest option that meets your needs and satisfies your use case. Integrations offer advantages beyond easier...
url: https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/agent-to-es
products:
  - Elastic Agent
  - Elastic Stack
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Elastic Agent to Elasticsearch
To ingest data into Elasticsearch, use the *simplest option that meets your needs* and satisfies your use case.
Integrations offer advantages beyond easier data collection—advantages such as dashboards, central agent management, and easy enablement of [Elastic solutions](https://www.elastic.co/products/), such as Security and Observability.
![Image showing Elastic Agent collecting data and sending to Elasticsearch](https://www.elastic.co/docs/manage-data/images/ingest-ea-es.png)


## Elastic Agent to Elasticsearch architectures

- [Elastic Agent to Elasticsearch: Agent installed](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/agent-installed)
- [Elastic Agent to Elasticsearch: APIs for collection](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/agent-apis)


## Resources

Info on Elastic Agent and agent integrations:
- [Fleet and Elastic Agent Guide](https://www.elastic.co/docs/reference/fleet)
- [Elastic Agent integrations](https://docs.elastic.co/en/integrations)

Info on Elasticsearch:
- [Elasticsearch Guide](https://www.elastic.co/docs/reference)

This basic architecture is a common approach for ingesting data for the [Elastic Observability](https://www.elastic.co/observability) and [Elastic Security](https://www.elastic.co/security) solutions:
- [Elastic Observability tutorials](https://www.elastic.co/docs/solutions/observability/get-started)
- [Ingest data to Elastic Security](https://www.elastic.co/docs/solutions/security/get-started/ingest-data-to-elastic-security)