﻿---
title: Elastic Agent to proxy to Elasticsearch
description: Currently Elastic Agent is not able to present a certificate for connectivity to Fleet Server. Therefore if a proxy placed between the Elastic Agent and...
url: https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/agent-proxy
products:
  - Elastic Agent
  - Elastic Stack
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Elastic Agent to proxy to Elasticsearch
![Image showing connections between Elastic Agent and Elasticsearch using a proxy when Fleet Server is managed by Elastic](https://www.elastic.co/docs/manage-data/images/ingest-ea-proxy-fs-es.png)

![Image showing connections between Elastic Agent and Elasticsearch using a proxy](https://www.elastic.co/docs/manage-data/images/ingest-ea-fs-proxy-es.png)

<tip>
  This architecture works with a variety of proxying tools to allow for more flexibility in your environment. Consider using [Logstash as a proxy](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/ls-networkbridge), as Logstash and the rest of the Elastic Stack are designed and tested to work together, and can be easier to support.
</tip>

<definitions>
  <definition term="Ingest model">
    Control path for Fleet Server on Elastic Cloud: Elastic Agent to proxy to Fleet Server to Elasticsearch Control path for self-managed Fleet Server: Elastic Agent to Fleet Server to proxy to Elasticsearch Data path: Elastic Agent to proxy to Elasticsearch
  </definition>
  <definition term="Use when">
    - Network restrictions prevent connection between Elastic Agent network and network where Fleet Server and Elastic Stack are deployed, as when Fleet Server is deployed on Elastic Cloud
    - Network restrictions prevent connection between Elastic Agent and Fleet Server network and the network where Elastic Stack is deployed, as when Elastic Stack is deployed on Elastic Cloud
    - Using [Logstash as proxy](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/ls-networkbridge) is not feasible.
  </definition>
</definitions>

Currently Elastic Agent is not able to present a certificate for connectivity to Fleet Server. Therefore if a proxy placed between the Elastic Agent and Fleet Server is configured for mutual TLS, Elastic Agents won’t be able to establish connectivity to Fleet Server.

## Resources

Info on Elastic Agent and agent integrations:
- [Fleet and Elastic Agent Guide](https://www.elastic.co/docs/reference/fleet)
- [Elastic Agent integrations](https://docs.elastic.co/en/integrations)

Info on using a proxy server:
- [Using a proxy server with Elastic Agent and Fleet](https://www.elastic.co/docs/reference/fleet/fleet-agent-proxy-support)

Info on Elasticsearch:
- [Elasticsearch Guide](https://www.elastic.co/docs/reference)