﻿---
title: Elastic Agent to Logstash: Air-gapped environment
description: Info for air-gapped environments: Installing the Elastic Stack in an air-gapped environment, Using a proxy server with Elastic Agent and Fleet. The Logstash...
url: https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/agent-ls-airgapped
products:
  - Elastic Agent
  - Elastic Stack
  - Logstash
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Elastic Agent to Logstash: Air-gapped environment
![Image showing Elastic Agent](https://www.elastic.co/docs/manage-data/images/ingest-ea-ls-airgapped.png)

<definitions>
  <definition term="Ingest model">
    All Elastic Stack components deployed inside a DMZ:
    - Control path: Elastic Agent to Fleet to Elasticsearch
    - Data path: Elastic Agent to Elasticsearch
  </definition>
  <definition term="Use when">
    Your self-managed Elastic Stack deployment has no access to outside networks
  </definition>
</definitions>


## Resources

Info for air-gapped environments:
- [Installing the Elastic Stack in an air-gapped environment](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/air-gapped-install)
- [Using a proxy server with Elastic Agent and Fleet](https://www.elastic.co/docs/reference/fleet/fleet-agent-proxy-support)


## Geoip database management in air-gapped environments

The [Logstash geoip filter](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-geoip) requires regular database updates to remain up-to-date with the latest information. If you are using the Logstash geoip filter plugin in an air-gapped environment, you can manage updates through a proxy, a custom endpoint, or manually. Check out [Manage your own database updates](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-geoip#plugins-filters-geoip-manage_update) for more info.