﻿---
title: Elastic Agent to Logstash to Kafka to Logstash to Elasticsearch: Kafka as middleware message queue
description: Info on Elastic Agent and agent integrations: Fleet and Elastic Agent Guide, Elastic Agent integrations. Info on Logstash and Logstash Kafka plugins: 
url: https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/agent-kafka-ls
products:
  - Elastic Agent
  - Elastic Stack
  - Logstash
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Elastic Agent to Logstash to Kafka to Logstash to Elasticsearch: Kafka as middleware message queue
![Image showing connections between Elastic Agent and Elasticsearch using a Kafka messaging queue](https://www.elastic.co/docs/manage-data/images/ingest-ls-kafka-ls.png)

<definitions>
  <definition term="Ingest model">
    Control path: Elastic Agent to Fleet to Elasticsearch Data path: Elastic Agent to Logstash to Kafka to Logstash to Elasticsearch: Kafka as middleware message queue.
    Logstash reads data from Kafka and routes it to Elasticsearch clusters (and/or other destinations)
  </definition>
  <definition term="Use when">
    You are standardizing on Kafka as middleware message queue between Elastic Agent and Elasticsearch
  </definition>
  <definition term="Notes">
    The transformation from raw data to Elastic Common Schema (ECS) and any other enrichment can be handled by Logstash as described in [Elastic Agent to Logstash (for enrichment) to Elasticsearch](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/ls-enrich).
  </definition>
</definitions>


## Resources

Info on Elastic Agent and agent integrations:
- [Fleet and Elastic Agent Guide](https://www.elastic.co/docs/reference/fleet)
- [Elastic Agent integrations](https://docs.elastic.co/en/integrations)

Info on Logstash and Logstash Kafka plugins:
- [Logstash Reference](https://www.elastic.co/docs/reference/logstash)
- [Logstash Elastic Agent input](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-elastic_agent)
- [Logstash Kafka input](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-kafka)
- [Logstash Kafka output](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-kafka)
- [Logstash Elasticsearch output](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch)

Info on Elasticsearch:
- [Elasticsearch Guide](https://www.elastic.co/docs/reference)