﻿---
title: Elastic Agent to Logstash to Kafka to Kafka ES Sink to Elasticsearch: Kafka as middleware message queue
description: Info on Elastic Agent and agent integrations: Fleet and Elastic Agent Guide, Elastic Agent integrations. Info on Logstash and Logstash plugins: Logstash...
url: https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/agent-kafka-essink
products:
  - Elastic Agent
  - Elastic Stack
  - Logstash
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Elastic Agent to Logstash to Kafka to Kafka ES Sink to Elasticsearch: Kafka as middleware message queue
![Image showing Elastic Agent collecting data and using Kafka as a message queue enroute to Elasticsearch](https://www.elastic.co/docs/manage-data/images/ingest-ls-kafka-essink.png)

<definitions>
  <definition term="Ingest model">
    Control path: Elastic Agent to Fleet to Elasticsearch Data path: Elastic Agent to Logstash to Kafka to Kafka ES Sink to Elasticsearch: Kafka as middleware message queue.
    Kafka ES Sink connector reads from Kafka and writes to Elasticsearch.
  </definition>
  <definition term="Use when">
    You are standardizing on Kafka as middleware message queue between Elastic Agent and Elasticsearch
  </definition>
  <definition term="Notes">
    The transformation from raw data to Elastic Common Schema (ECS) and any other enrichment can be handled by Logstash as described in [Elastic Agent to Logstash (for enrichment) to Elasticsearch](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/ls-enrich).
  </definition>
</definitions>


## Resources

Info on Elastic Agent and agent integrations:
- [Fleet and Elastic Agent Guide](https://www.elastic.co/docs/reference/fleet)
- [Elastic Agent integrations](https://docs.elastic.co/en/integrations)

Info on Logstash and Logstash plugins:
- [Logstash Reference](https://www.elastic.co/docs/reference/logstash)
- [Logstash Elastic Agent input](https://www.elastic.co/docs/reference/logstash/plugins/plugins-inputs-elastic_agent)
- [Logstash Kafka output](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-kafka)

Info on Elasticsearch:
- [Elasticsearch Guide](https://www.elastic.co/docs/reference)
- ES sink [ToDo: Add link]