﻿---
title: Elastic Agent to Elasticsearch with Kafka as middleware message queue
description: Elastic Agent to Logstash to Kafka to Logstash to Elasticsearch: Kafka as middleware message queue, Elastic Agent to Logstash to Kafka to Kafka ES Sink...
url: https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/agent-kafka-es
products:
  - Elastic Agent
  - Elastic Stack
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Elastic Agent to Elasticsearch with Kafka as middleware message queue
![Image showing Elastic Agent collecting data and using Kafka as a message queue enroute to Elasticsearch](https://www.elastic.co/docs/manage-data/images/ingest-ea-kafka.png)

<definitions>
  <definition term="Ingest models">
    [Elastic Agent to Logstash to Kafka to Logstash to Elasticsearch: Kafka as middleware message queue](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/agent-kafka-ls). Logstash reads data from Kafka and routes it to Elasticsearch clusters and other destinations.
    [Elastic Agent to Logstash to Kafka to Kafka ES Sink to Elasticsearch: Kafka as middleware message queue](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/agent-kafka-essink). Kafka ES sink connector reads from Kafka and writes to Elasticsearch.
  </definition>
  <definition term="Use when">
    You are standardizing on Kafka as middleware message queue between Elastic Agent and Elasticsearch
  </definition>
  <definition term="Notes">
    The transformation from raw data to Elastic Common Schema (ECS) and any other enrichment can be handled by Logstash as described in [Elastic Agent to Logstash (for enrichment) to Elasticsearch](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/ls-enrich).
  </definition>
</definitions>


## Elastic Agent with Kafka as middleware message queue architectures

- [Elastic Agent to Logstash to Kafka to Logstash to Elasticsearch: Kafka as middleware message queue](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/agent-kafka-ls)
- [Elastic Agent to Logstash to Kafka to Kafka ES Sink to Elasticsearch: Kafka as middleware message queue](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/agent-kafka-essink)