﻿---
title: Elastic Agent to Elasticsearch: APIs for collection
description: Find the integration for your data source. In Kibana,  go to Management> Integrations.Enable the integration and set up Elastic Agent.Create a collector...
url: https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/agent-apis
products:
  - Elastic Agent
  - Elastic Stack
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Elastic Agent to Elasticsearch: APIs for collection
![Image showing Elastic Agent collecting data using APIs and sending to Elasticsearch](https://www.elastic.co/docs/manage-data/images/ingest-ea-apis.png)

<definitions>
  <definition term="Ingest model">
    Control path: Elastic Agent to Fleet to Elasticsearch Data path: Elastic Agent running on a user-managed host to collect data about the external infrastructure through APIs, and then forwarding to Elasticsearch
  </definition>
  <definition term="Use when">
    An Elastic Agent integration exists for software components that expose APIs for data collection
  </definition>
  <definition term="Examples">
    Cloudflare or any other data sources that exposes API for data retrieval
  </definition>
</definitions>


## Process overview

- Find the integration for your data source. In Kibana,  go to **Management> Integrations**.
- Enable the integration and set up Elastic Agent.
- Create a collector VM/container and run Elastic Agent and the integration to scrape the external API. Or, set up the external API to push data to the Elastic Agent running the integration.

For details and next steps, check out the [Elastic Agent integrations](https://docs.elastic.co/en/integrations) docs for your data source.