﻿---
title: Ingest architectures
description: We offer a variety of ingest architectures to serve a wide range of use cases and network configurations. To ingest data into Elasticsearch, use the simplest...
url: https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures
products:
  - Elastic Agent
  - Elastic Stack
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Ingest architectures
We offer a variety of ingest architectures to serve a wide range of use cases and network configurations.
To ingest data into Elasticsearch, use the *simplest option that meets your needs* and satisfies your use case. For many users and use cases, the simplest approach is ingesting data with Elastic Agent and sending it to Elasticsearch. Elastic Agent and [Elastic Agent integrations](https://www.elastic.co/integrations/) are available for many popular platforms and services, and are a good place to start.
<tip>
  You can host Elasticsearch on your own hardware or send your data to Elasticsearch on Elastic Cloud. For most users, Elastic Agent writing directly to Elasticsearch on Elastic Cloud provides the easiest and fastest time to value. Elastic Cloud Hosted is available on AWS, GCP, and Azure, and you can [try it for free](https://cloud.elastic.co/registration).
</tip>

<admonition title="Elastic Cloud Serverless architectures">
  Architecture diagrams show Elasticsearch and Kibana as separate components. Elasticsearch and Kibana are combined in your Serverless project.
</admonition>

**Decision tree**
[Data ingestion](https://www.elastic.co/docs/manage-data/ingest)

| **Ingest architecture**                                                                                                                                                                                                                                                                                                                               | **Use when**                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [*Elastic Agent to Elasticsearch*](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/agent-to-es)![Image showing Elastic Agent collecting data and sending to Elasticsearch](https://www.elastic.co/docs/manage-data/images/ingest-ea-es.png)                                                                             | An [Elastic Agent integration](https://docs.elastic.co/en/integrations) is available for your data source:* Software components with [Elastic Agent installed](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/agent-installed)* Software components using [APIs for data collection](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/agent-apis)                                                                                                                                                                                                                                                                                                                                                                                                                         |
| [*Elastic Agent to Logstash to Elasticsearch*](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/agent-ls)![Image showing Elastic Agent to Logstash to Elasticsearch](https://www.elastic.co/docs/manage-data/images/ingest-ea-ls-es.png)                                                                                 | You need additional capabilities offered by Logstash:* [**enrichment**](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/ls-enrich) between Elastic Agent and Elasticsearch* [**persistent queue (PQ) buffering**](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/lspq) to accommodate network issues and downstream unavailability* [**proxying**](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/ls-networkbridge) in cases where Elastic Agents have network restrictions for connecting outside of the Elastic Agent network* data needs to be [**routed to multiple**](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/ls-multi) Elasticsearch clusters and other destinations depending on the content |
| [*Elastic Agent to proxy to Elasticsearch*](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/agent-proxy)![Image showing connections between Elastic Agent and Elasticsearch using a proxy](https://www.elastic.co/docs/manage-data/images/ingest-ea-proxy-es.png)                                                       | Agents have [network restrictions](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/agent-proxy) that prevent connecting outside of the Elastic Agent network. [Logstash as proxy](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/ls-networkbridge) is one option.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| [*Elastic Agent to Elasticsearch with Kafka as middleware message queue*](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/agent-kafka-es)![Image showing Elastic Agent collecting data and using Kafka as a message queue enroute to Elasticsearch](https://www.elastic.co/docs/manage-data/images/ingest-ea-kafka.png) | Kafka is your [middleware message queue](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/agent-kafka-es):* [Kafka ES sink connector](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/agent-kafka-essink) to write from Kafka to Elasticsearch* [Logstash to read from Kafka and route to Elasticsearch](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/agent-kafka-ls)                                                                                                                                                                                                                                                                                                                                                                     |
| [*Logstash to Elasticsearch*](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/ls-for-input)![Image showing Logstash collecting data and sending to Elasticsearch](https://www.elastic.co/docs/manage-data/images/ingest-ls-es.png)                                                                                      | You need to collect data from a source that Elastic Agent can’t read (such as databases, AWS Kinesis). Check out the [Logstash input plugins](https://www.elastic.co/docs/reference/logstash/plugins/input-plugins).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| [*Elastic air-gapped architectures*](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures/airgapped-env) <applies-to>Elastic Cloud Serverless: Unavailable</applies-to>![Image showing Elastic Stack in an air-gapped environment](https://www.elastic.co/docs/manage-data/images/ingest-ea-airgapped.png)                   | You want to deploy Elastic Agent and Elastic Stack in an air-gapped environment (no access to outside networks)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |