﻿---
title: Specify an analyzer
description: Elasticsearch offers a variety of ways to specify built-in or custom analyzers: By text field, index, or query, For index or search time. Elasticsearch...
url: https://www.elastic.co/docs/manage-data/data-store/text-analysis/specify-an-analyzer
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Specify an analyzer
Elasticsearch offers a variety of ways to specify built-in or custom analyzers:
- By `text` field, index, or query
- For [index or search time](https://www.elastic.co/docs/manage-data/data-store/text-analysis/index-search-analysis)

<admonition title="Keep it simple">
  The flexibility to specify analyzers at different levels and for different times is great… *but only when it’s needed*.In most cases, a simple approach works best: Specify an analyzer for each `text` field, as outlined in [Specify the analyzer for a field](#specify-index-field-analyzer).This approach works well with Elasticsearch's default behavior, letting you use the same analyzer for indexing and search. It also lets you quickly see which analyzer applies to which field using the [get mapping API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-get-mapping).If you don’t typically create mappings for your indices, you can use [index templates](https://www.elastic.co/docs/manage-data/data-store/templates) to achieve a similar effect.
</admonition>


## How Elasticsearch determines the index analyzer

Elasticsearch determines which index analyzer to use by checking the following parameters in order:
1. The [`analyzer`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/analyzer) mapping parameter for the field. See [Specify the analyzer for a field](#specify-index-field-analyzer).
2. The `analysis.analyzer.default` index setting. See [Specify the default analyzer for an index](#specify-index-time-default-analyzer).

If none of these parameters are specified, the [`standard` analyzer](https://www.elastic.co/docs/reference/text-analysis/analysis-standard-analyzer) is used.

## Specify the analyzer for a field

When mapping an index, you can use the [`analyzer`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/analyzer) mapping parameter to specify an analyzer for each `text` field.
The following [create index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) request sets the `whitespace` analyzer as the analyzer for the `title` field.
```json

{
  "mappings": {
    "properties": {
      "title": {
        "type": "text",
        "analyzer": "whitespace"
      }
    }
  }
}
```


## Specify the default analyzer for an index

In addition to a field-level analyzer, you can set a fallback analyzer for using the `analysis.analyzer.default` setting.
The following [create index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) request sets the `simple` analyzer as the fallback analyzer for `my-index-000001`.
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "default": {
          "type": "simple"
        }
      }
    }
  }
}
```


## How Elasticsearch determines the search analyzer

<warning>
  In most cases, specifying a different search analyzer is unnecessary. Doing so could negatively impact relevancy and result in unexpected search results.If you choose to specify a separate search analyzer, we recommend you thoroughly [test your analysis configuration](https://www.elastic.co/docs/manage-data/data-store/text-analysis/test-an-analyzer) before deploying in production.
</warning>

At search time, Elasticsearch determines which analyzer to use by checking the following parameters in order:
1. The [`analyzer`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/analyzer) parameter in the search query. See [Specify the search analyzer for a query](#specify-search-query-analyzer).
2. The [`search_analyzer`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/search-analyzer) mapping parameter for the field. See [Specify the search analyzer for a field](#specify-search-field-analyzer).
3. The `analysis.analyzer.default_search` index setting. See [Specify the default search analyzer for an index](#specify-search-default-analyzer).
4. The [`analyzer`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/analyzer) mapping parameter for the field. See [Specify the analyzer for a field](#specify-index-field-analyzer).

If none of these parameters are specified, the [`standard` analyzer](https://www.elastic.co/docs/reference/text-analysis/analysis-standard-analyzer) is used.

## Specify the search analyzer for a query

When writing a [full-text query](https://www.elastic.co/docs/reference/query-languages/query-dsl/full-text-queries), you can use the `analyzer` parameter to specify a search analyzer. If provided, this overrides any other search analyzers.
The following [search API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search) request sets the `stop` analyzer as the search analyzer for a [`match`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-match-query) query.
```json

{
  "query": {
    "match": {
      "message": {
        "query": "Quick foxes",
        "analyzer": "stop"
      }
    }
  }
}
```


## Specify the search analyzer for a field

When mapping an index, you can use the [`search_analyzer`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/analyzer) mapping parameter to specify a search analyzer for each `text` field.
If a search analyzer is provided, the index analyzer must also be specified using the `analyzer` parameter.
The following [create index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) request sets the `simple` analyzer as the search analyzer for the `title` field.
```json

{
  "mappings": {
    "properties": {
      "title": {
        "type": "text",
        "analyzer": "whitespace",
        "search_analyzer": "simple"
      }
    }
  }
}
```


## Specify the default search analyzer for an index

When [creating an index](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create), you can set a default search analyzer using the `analysis.analyzer.default_search` setting.
If a search analyzer is provided, a default index analyzer must also be specified using the `analysis.analyzer.default` setting.
The following  [create index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) request sets the `whitespace` analyzer as the default search analyzer for the `my-index-000001` index.
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "default": {
          "type": "simple"
        },
        "default_search": {
          "type": "whitespace"
        }
      }
    }
  }
}
```


## Update analyzers on existing indices

<applies-to>
  - Elastic Cloud Serverless: Unavailable
</applies-to>

You can only define new analyzers on closed indices. To add an analyzer, you must close the index, define the analyzer, and reopen the index.
For example, the following commands add the `content` analyzer to the `my-index-000001` index:
```json
```

```json

{
  "analysis" : {
    "analyzer":{
      "content":{
        "type":"custom",
        "tokenizer":"whitespace"
      }
    }
  }
}
```

```json
```

<warning>
  You cannot close the write index of a data stream. To update the analyzer for a data stream's write index and future backing indices, update the analyzer in the [index template](/docs/manage-data/data-store/data-streams/set-up-data-stream#create-index-template) used by the stream. Then [roll over the data stream](/docs/manage-data/data-store/data-streams/use-data-stream#manually-roll-over-a-data-stream) to apply the new analyzer to the stream's write index and future backing indices. This affects searches and any new data added to the stream after the rollover. However, it does not affect the data stream's backing indices or their existing data.To change the analyzer for existing backing indices, you must create a new data stream and reindex your data into it. See [Use reindex to change mappings or settings](/docs/manage-data/data-store/data-streams/modify-data-stream#data-streams-use-reindex-to-change-mappings-settings).
</warning>