﻿---
title: Configuring built-in analyzers
description: The built-in analyzers can be used directly without any configuration. Some of them, however, support configuration options to alter their behavior. For...
url: https://www.elastic.co/docs/manage-data/data-store/text-analysis/configuring-built-in-analyzers
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Configuring built-in analyzers
The built-in analyzers can be used directly without any configuration. Some of them, however, support configuration options to alter their behavior. For instance, the [`standard` analyzer](https://www.elastic.co/docs/reference/text-analysis/analysis-standard-analyzer) can be configured to support a list of stop words:
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "std_english": { <1>
          "type":      "standard",
          "stopwords": "_english_"
        }
      }
    }
  },
  "mappings": {
    "properties": {
      "my_text": {
        "type":     "text",
        "analyzer": "standard", <2>
        "fields": {
          "english": {
            "type":     "text",
            "analyzer": "std_english" <3>
          }
        }
      }
    }
  }
}


{
  "field": "my_text", <2>
  "text": "The old brown cow"
}


{
  "field": "my_text.english", <3>
  "text": "The old brown cow"
}
```