﻿---
title: Configure text analysis
description: By default, Elasticsearch uses the standard analyzer for all text analysis. The standard analyzer gives you out-of-the-box support for most natural languages...
url: https://www.elastic.co/docs/manage-data/data-store/text-analysis/configure-text-analysis
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Configure text analysis
By default, Elasticsearch uses the [`standard` analyzer](https://www.elastic.co/docs/reference/text-analysis/analysis-standard-analyzer) for all text analysis. The `standard` analyzer gives you out-of-the-box support for most natural languages and use cases. If you chose to use the `standard` analyzer as-is, no further configuration is needed.
If the standard analyzer does not fit your needs, review and test Elasticsearch's other built-in [built-in analyzers](https://www.elastic.co/docs/reference/text-analysis/analyzer-reference). Built-in analyzers don’t require configuration, but some support options that can be used to adjust their behavior. For example, you can configure the `standard` analyzer with a list of custom stop words to remove.
If no built-in analyzer fits your needs, you can test and create a custom analyzer. Custom analyzers involve selecting and combining different [analyzer components](https://www.elastic.co/docs/manage-data/data-store/text-analysis/anatomy-of-an-analyzer), giving you greater control over the process.
- [Test an analyzer](https://www.elastic.co/docs/manage-data/data-store/text-analysis/test-an-analyzer)
- [Configuring built-in analyzers](https://www.elastic.co/docs/manage-data/data-store/text-analysis/configuring-built-in-analyzers)
- [Create a custom analyzer](https://www.elastic.co/docs/manage-data/data-store/text-analysis/create-custom-analyzer)
- [Specify an analyzer](https://www.elastic.co/docs/manage-data/data-store/text-analysis/specify-an-analyzer)