﻿---
title: Simulate multi-component templates
description: Since templates can be composed not only of multiple component templates, but also the index template itself, there are two simulation APIs to determine...
url: https://www.elastic.co/docs/manage-data/data-store/templates/simulate-multi-component-templates
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Simulate multi-component templates
Since templates can be composed not only of multiple component templates, but also the index template itself, there are two simulation APIs to determine what the resulting index settings will be.
To simulate the settings that would be applied to a particular index name:
```json
```

To simulate the settings that would be applied from an existing template:
```json
```

You can also specify a template definition in the simulate request. This enables you to verify that settings will be applied as expected before you add a new template.
```json

{
  "template": {
    "settings": {
      "index.number_of_shards": 2
    }
  }
}


{
  "template": {
    "settings": {
      "index.number_of_replicas": 0
    },
    "mappings": {
      "properties": {
        "@timestamp": {
          "type": "date"
        }
      }
    }
  }
}


{
  "index_patterns": ["my*"],
  "template": {
    "settings" : {
        "index.number_of_shards" : 3
    }
  },
  "composed_of": ["ct1", "ct2"]
}
```

The response shows the settings, mappings, and aliases that would be applied to matching indices, and any overlapping templates whose configuration would be superseded by the simulated template body or higher-priority templates.
```json
{
  "template" : {
    "settings" : {
      "index" : {
        "number_of_shards" : "3",   
        "number_of_replicas" : "0",
        "routing" : {
          "allocation" : {
            "include" : {
              "_tier_preference" : "data_content"
            }
          }
        }
      }
    },
    "mappings" : {
      "properties" : {
        "@timestamp" : {
          "type" : "date"           
        }
      }
    },
    "aliases" : { }
  },
  "overlapping" : [
    {
      "name" : "template_1",        
      "index_patterns" : [
        "my*"
      ]
    }
  ]
}
```