﻿---
title: Ignore missing component templates
description: When an index template references a component template that might not exist, the ignore_missing_component_templates configuration option can be used...
url: https://www.elastic.co/docs/manage-data/data-store/templates/ignore-missing-component-templates
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Ignore missing component templates
When an index template references a component template that might not exist, the `ignore_missing_component_templates` configuration option can be used. With this option, every time a data stream is created based on the index template, the existence of the component template will be checked. If it exists, it will used to form the index’s composite settings. If it is missing, it will be ignored.
The following example demonstrates how this configuration option works.

## Example: Use the `ignore_missing_component_templates` option

In this example, an index template and one component template are created. The index template references two component templates, but only one exists.
Suppose the `logs-foo_component1` component template is created *before* the index template:
```json

{
  "template": {
    "mappings": {
      "properties": {
        "host.name": {
          "type": "keyword"
        }
      }
    }
  }
}
```

Next, an index template is created, referencing two component templates:
```JSON
  "composed_of": ["logs-foo_component1", "logs-foo_component2"]
```

Since only the `logs-foo_component1` component template was created previously, the `logs-foo_component2` component template is missing. The following entry is added to the configuration:
```JSON
  "ignore_missing_component_templates": ["logs-foo_component2"],
```

The `logs-foo` index template will successfully be created, but it will not validate that `logs-foo_component2` exists:
```json

{
  "index_patterns": ["logs-foo-*"],
  "data_stream": { },
  "composed_of": ["logs-foo_component1", "logs-foo_component2"],
  "ignore_missing_component_templates": ["logs-foo_component2"],
  "priority": 500
}
```

A data stream can be created based on this template:
```json
```

The mappings of the data stream will contain the `host.name` field.
The missing component template can be added later:
```json

{
  "template": {
    "mappings": {
      "properties": {
        "host.ip": {
          "type": "ip"
        }
      }
    }
  }
}
```

This will not have an immediate effect on the data stream. The mapping `host.ip` will only show up in the data stream mappings when the data stream is rolled over automatically next time or a manual rollover is triggered:
```json
```