﻿---
title: Perform operations on indices
description: You can perform a number of index operations from the Index management page in Kibana. To perform index actions: Go to the Index management page using...
url: https://www.elastic.co/docs/manage-data/data-store/perform-index-operations
products:
  - Elastic Cloud Serverless
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Perform operations on indices
You can perform a number of index operations from the **Index management** page in Kibana.
To perform index actions:
1. Go to the **Index management** page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Enable **Include hidden indices** to view the full set of indices, including backing indices for [data streams](https://www.elastic.co/docs/manage-data/data-store/data-streams).
3. Open the **Indices** view.
4. Click the index name, or to perform operations on multiple indices select their checkboxes and open the **Manage index** menu.


## Available index operations

Several index operations are available from the **Manage index** menu. Some of the operations listed are unavailable in Elastic Cloud Serverless since in that environment many data management tasks are handled automatically.
<definitions>
  <definition term="Show index overview Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    View an overview of the index, including its storage size, status, and aliases, as well as a sample API request to add new documents.
  </definition>
  <definition term="Show index settings Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    View a list of the currently configured [index settings](https://www.elastic.co/docs/reference/elasticsearch/index-settings). Enable **Edit mode** to add or change settings.
  </definition>
  <definition term="Show index mapping Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    View the [index mappings](https://www.elastic.co/docs/manage-data/data-store/mapping). From this page you can set up new mappings for the field types in your index.
  </definition>
  <definition term="Show index stats Elastic Stack: Generally available">
    View statistics for your index. Statistics are compiled by `primaries`, representing values only for primary shards, and by `total`, representing accumulated values for both primary and replica shards. Refer to the [get index statistics](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-stats) API for details.
  </definition>
  <definition term="Close index Elastic Stack: Generally available">
    Close the index so that read or write operations cannot be performed. Refer to the [close index](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-close) API for details.
  </definition>
  <definition term="Open index Elastic Stack: Generally available">
    Reopen an index that is currently closed to read and write operations. This option is available only for indices that are currently closed. Refer to the [open index](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-open) API for details.
  </definition>
  <definition term="Force merge index Elastic Stack: Generally available">
    Perform a force merge operation on the shards of the indices. This reduces the number of segments in each shard by merging some of them together and also frees up the space used by deleted documents. Refer to the [force merge](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-forcemerge) API for details.
  </definition>
  <definition term="Refresh index Elastic Stack: Generally available">
    Refresh the index to make the most recent operations performed on the index available for search. Refer to the [refresh index](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-refresh) API for details.
  </definition>
  <definition term="Clear index cache Elastic Stack: Generally available">
    Clear all of the caches for the index. Refer to the [clear cache](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-clear-cache) API for details.
  </definition>
  <definition term="Flush index Elastic Stack: Generally available">
    Flush the index to ensure that all data currently stored only in the transaction log is stored permanently in the Lucene index. Refer to the [flush index](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-flush) API for details.
  </definition>
  <definition term="Delete index Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    Delete an index including all of its documents, shards, and metadata. Refer to the [delete index](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-delete) API for details.
  </definition>
  <definition term="Add lifecycle policy Elastic Stack: Generally available">
    Add a lifecycle policy to the index to manage how it transitions over time. The policy governs how the index moves through different phases (`hot`, `warm`, `cold`, `frozen`, and `delete`) and what actions, such as shrinking and downsampling, are performed on the index during each of these phases. Refer to [Index lifecycle management](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management) to learn more.
  </definition>
  <definition term="Convert to lookup index Elastic Stack: Preview since 9.2 Elastic Cloud Serverless: Preview">
    Convert the index to a lookup mode index that can be used with [`LOOKUP JOIN`](https://www.elastic.co/docs/reference/query-languages/esql/commands/lookup-join) commands, so that data from the index can be added to ES|QL query results. This option is available only for single shard indices that have less than two billion documents. Refer to the Elasticsearch [`index.mode`](https://www.elastic.co/docs/reference/elasticsearch/index-settings/index-modules#index-mode-setting) index setting for details.
  </definition>
</definitions>