﻿---
title: Dynamic mapping
description: One of the most important features of Elasticsearch is that it tries to get out of your way and let you start exploring your data as quickly as possible...
url: https://www.elastic.co/docs/manage-data/data-store/mapping/dynamic-mapping
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Dynamic mapping
One of the most important features of Elasticsearch is that it tries to get out of your way and let you start exploring your data as quickly as possible. To index a document, you don’t have to first create an index, define a mapping type, and define your fields — you can just index a document and the index, type, and fields will display automatically:
```json
PUT data/_doc/1 
{ "count": 5 }
```

The automatic detection and addition of new fields is called *dynamic mapping*. The dynamic mapping rules can be customized to suit your purposes with:
<definitions>
  <definition term="Dynamic field mappings">
    The rules governing dynamic field detection.
  </definition>
  <definition term="Dynamic templates">
    Custom rules to configure the mapping for dynamically added fields.
  </definition>
</definitions>

<tip>
  [Index templates](https://www.elastic.co/docs/manage-data/data-store/templates) allow you to configure the default mappings, settings and aliases for new indices, whether created automatically or explicitly.
</tip>