﻿---
title: Dynamic field mapping
description: When Elasticsearch detects a new field in a document, it dynamically adds the field to the type mapping by default. The dynamic parameter controls this...
url: https://www.elastic.co/docs/manage-data/data-store/mapping/dynamic-field-mapping
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Dynamic field mapping
When Elasticsearch detects a new field in a document, it *dynamically* adds the field to the type mapping by default. The [`dynamic`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/dynamic) parameter controls this behavior.
You can explicitly instruct Elasticsearch to dynamically create fields based on incoming documents by setting the `dynamic` parameter to `true` or `runtime`. When dynamic field mapping is enabled, Elasticsearch uses the rules in the following table to determine how to map data types for each field.
<note>
  The field data types in the following table are the only [field data types](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/field-data-types) that Elasticsearch detects dynamically. You must explicitly map all other data types.
</note>



| JSON data type                                                     | Elasticsearch data type(`"dynamic":"true"`)        | Elasticsearch data type(`"dynamic":"runtime"`)     |
|--------------------------------------------------------------------|----------------------------------------------------|----------------------------------------------------|
| `null`                                                             | No field added                                     | No field added                                     |
| `true` or `false`                                                  | `boolean`                                          | `boolean`                                          |
| `double`                                                           | `float`                                            | `double`                                           |
| `long`                                                             | `long`                                             | `long`                                             |
| `object`                                                           | `object`                                           | No field added                                     |
| `array`                                                            | Depends on the first non-`null` value in the array | Depends on the first non-`null` value in the array |
| `string` that passes [date detection](#date-detection)             | `date`                                             | `date`                                             |
| `string` that passes [numeric detection](#numeric-detection)       | `float` or `long`                                  | `double` or `long`                                 |
| `string` that doesn’t pass `date` detection or `numeric` detection | `text` with a `.keyword` sub-field                 | `keyword`                                          |

You can disable dynamic mapping, both at the document and at the [`object`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/object) level. Setting the `dynamic` parameter to `false` ignores new fields, and `strict` rejects the document if Elasticsearch encounters an unknown field.
<tip>
  Use the [update mapping API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-mapping) to update the `dynamic` setting on existing fields.
</tip>

You can customize dynamic field mapping rules for [date detection](#date-detection) and [numeric detection](#numeric-detection). To define custom mappings rules that you can apply to additional dynamic fields, use [`dynamic_templates`](https://www.elastic.co/docs/manage-data/data-store/mapping/dynamic-templates).

## Date detection

If `date_detection` is enabled (default), then new string fields are checked to see whether their contents match any of the date patterns specified in `dynamic_date_formats`. If a match is found, a new [`date`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/date) field is added with the corresponding format.
The default value for `dynamic_date_formats` is:
[ [`"strict_date_optional_time"`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-date-format#strict-date-time),`"yyyy/MM/dd HH:mm:ss Z||yyyy/MM/dd Z"`]
For example:
```json

{
  "create_date": "2015/09/02"
}
```


### Disabling date detection

Dynamic date detection can be disabled by setting `date_detection` to `false`:
```json

{
  "mappings": {
    "date_detection": false
  }
}


{
  "create_date": "2015/09/02"
}
```


### Customizing detected date formats

Alternatively, the `dynamic_date_formats` can be customized to support your own [date formats](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-date-format):
```json

{
  "mappings": {
    "dynamic_date_formats": ["MM/dd/yyyy"]
  }
}


{
  "create_date": "09/25/2015"
}
```

<note>
  There is a difference between configuring an array of date patterns and configuring multiple patterns in a single string separated by `||`. When you configure an array of date patterns, the pattern that matches the date in the first document with an unmapped date field will determine the mapping of that field:
  ```json

  {
    "mappings": {
      "dynamic_date_formats": [ "yyyy/MM", "MM/dd/yyyy"]
    }
  }


  {
    "create_date": "09/25/2015"
  }
  ```
  The resulting mapping will be:
  ```json
  {
    "my-index-000001": {
      "mappings": {
        "dynamic_date_formats": [
          "yyyy/MM",
          "MM/dd/yyyy"
        ],
        "properties": {
          "create_date": {
            "type": "date",
            "format": "MM/dd/yyyy"
          }
        }
      }
    }
  }
  ```
  Configuring multiple patterns in a single string separated by `||` results in a mapping that supports any of the date formats. This enables you to index documents that use different formats:
  ```json

  {
    "mappings": {
      "dynamic_date_formats": [ "yyyy/MM||MM/dd/yyyy"]
    }
  }


  {
    "create_date": "09/25/2015"
  }
  ```
  The resulting mapping will be:
  ```json
  {
    "my-index-000001": {
      "mappings": {
        "dynamic_date_formats": [
          "yyyy/MM||MM/dd/yyyy"
        ],
        "properties": {
          "create_date": {
            "type": "date",
            "format": "yyyy/MM||MM/dd/yyyy"
          }
        }
      }
    }
  }
  ```
</note>

<note>
  Epoch formats (`epoch_millis` and `epoch_second`) are not supported as dynamic date formats.
</note>


## Numeric detection

While JSON has support for native floating point and integer data types, some applications or languages may sometimes render numbers as strings. Usually the correct solution is to map these fields explicitly, but numeric detection (which is disabled by default) can be enabled to do this automatically:
```json

{
  "mappings": {
    "numeric_detection": true
  }
}


{
  "my_float":   "1.0", <1>
  "my_integer": "1" <2>
}
```