﻿---
title: Mapping
description: Mapping is the process of defining how a document and the fields it contains are stored and indexed. Each document is a collection of fields, which each...
url: https://www.elastic.co/docs/manage-data/data-store/mapping
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Mapping
Mapping is the process of defining how a document and the fields it contains are stored and indexed.
Each document is a collection of fields, which each have their own [data type](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/field-data-types). When mapping your data, you create a mapping definition, which contains a list of fields that are pertinent to the document. A mapping definition also includes [metadata fields](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/document-metadata-fields), like the `_source` field, which customize how a document’s associated metadata is handled.
Depending on where you are in your data journey, use *dynamic mapping* and *explicit mapping* to define your data. For example, you can explicitly map fields where you don’t want to use the defaults, or to gain greater control over which fields are created. Then you can allow Elasticsearch to dynamically map other fields. Using a combination of dynamic and explicit mapping on the same index is especially useful when you have a mix of known and unknown fields in your data.
<note>
  Before 7.0.0, the mapping definition included a type name. Elasticsearch 7.0.0 and later no longer accept a default mapping. [Removal of mapping types](https://www.elastic.co/docs/manage-data/data-store/mapping/removal-of-mapping-types) provides more information.
</note>


## Dynamic mapping

When you use [dynamic mapping](https://www.elastic.co/docs/manage-data/data-store/mapping/dynamic-mapping), Elasticsearch automatically detects the data types of fields in your documents and creates mappings for you. If you index additional documents with new fields, Elasticsearch will add these fields automatically. You can add fields to the top-level mapping, and to inner [`object`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/object) and [`nested`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/nested) fields. Dynamic mapping helps you get started quickly, but might yield suboptimal results for your specific use case due to automatic field type inference.
Use [dynamic templates](https://www.elastic.co/docs/manage-data/data-store/mapping/dynamic-templates) to define custom mappings that are applied to dynamically added fields based on the matching condition.

## Explicit mapping

Use [explicit mapping](https://www.elastic.co/docs/manage-data/data-store/mapping/explicit-mapping) to define mappings by specifying data types for each field. This is recommended for production use cases, because you have full control over how your data is indexed to suit your specific use case.
Defining your own mappings enables you to:
- Define which string fields should be treated as full-text fields.
- Define which text field can be automatically vectorized by a semantic search machine learning model.
- Define which fields contain numbers, dates, or geolocations.
- Use data types that cannot be automatically detected (such as `geo_point` and `geo_shape`.)
- Choose date value [formats](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-date-format), including custom date formats.
- Create custom rules to control the mapping for [dynamically added fields](https://www.elastic.co/docs/manage-data/data-store/mapping/dynamic-mapping).
- Optimize fields for partial matching.
- Perform language-specific text analysis.

<tip>
  It’s often useful to index the same field in different ways for different purposes. For example, you might want to index a string field as both a text field for full-text search and as a keyword field for sorting or aggregating your data. Or, you might choose to use more than one language analyzer to process the contents of a string field that contains user input.
</tip>


## Runtime fields

Use [runtime fields](https://www.elastic.co/docs/manage-data/data-store/mapping/runtime-fields) to make schema changes without reindexing. You can use runtime fields in conjunction with indexed fields to balance resource usage and performance. Your index will be smaller, but with slower search performance.
<admonition title="Experiment with mapping options">
  [Define runtime fields in a search request](https://www.elastic.co/docs/manage-data/data-store/mapping/define-runtime-fields-in-search-request) to experiment with different mapping options, and also fix mistakes in your index mapping values by overriding values in the mapping during the search request.
</admonition>


## Manage and update mappings

Explicit mappings should be defined at index creation for fields you know in advance. You can still add new fields to mappings at any time, as your data evolves.
Use the [Update mapping API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-mapping) to update an existing mapping.
In most cases, you can’t change mappings for fields that are already mapped. These changes require [reindexing](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-reindex).
However, you can update mappings under certain conditions:
- You can add new fields to an existing mapping at any time, dynamically or explicitly.
- You can add new [multi-fields](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/multi-fields) for existing fields.
  - Documents indexed before the mapping update will not have values for the new multi-fields until they are updated or reindexed. Documents indexed after the mapping change will automatically have values for the new multi-fields.
- Some [mapping parameters](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-parameters) can be updated for existing fields of certain [data types](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/field-data-types).


## Prevent mapping explosions

Defining too many fields in an index can lead to a mapping explosion, which can cause out of memory errors and difficult situations from which to recover.
Consider a situation where every new document inserted introduces new fields, such as with [dynamic mapping](https://www.elastic.co/docs/manage-data/data-store/mapping/dynamic-mapping). Each new field is added to the index mapping, which can become a problem as the mapping grows.
Use the [mapping limit settings](https://www.elastic.co/docs/reference/elasticsearch/index-settings/mapping-limit) to limit the number of field mappings (created manually or dynamically) and prevent documents from causing a mapping explosion.