﻿---
title: Time series data streams
description: A time series data stream (TSDS) is a type of data stream optimized for indexing metrics data. A TSDS helps you analyze a sequence of data points as a...
url: https://www.elastic.co/docs/manage-data/data-store/data-streams/time-series-data-stream-tsds
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Time series data streams
A time series data stream (TSDS) is a type of [data stream](https://www.elastic.co/docs/manage-data/data-store/data-streams) optimized for indexing metrics data. A TSDS helps you analyze a sequence of data points as a whole.
A TSDS can also help you store metrics data more efficiently. In our benchmarks, metrics data stored in a TSDS used 70% less disk space than a regular data stream. The exact impact varies by data set.
Before setting up a time series data stream, make sure you're familiar with general [data stream](https://www.elastic.co/docs/manage-data/data-store/data-streams) concepts.

## When to use a time series data stream

_Metrics_ consist of data pointtimestamp pairs, identified by [dimension fields](#time-series-dimension), that can be used in aggregation queries. Both a regular data stream and a time series data stream can store metrics data.
Choose a time series data stream if you typically add metrics data to Elasticsearch in near real-time and in `@timestamp` order. For other timestamped data, such as logs or traces, use a [logs data stream](https://www.elastic.co/docs/manage-data/data-store/data-streams/logs-data-stream) or a [regular data stream](https://www.elastic.co/docs/manage-data/data-store/data-streams).
To make sure a TSDS is right for your use case, review the list of [differences from a regular data stream](#differences-from-regular-data-stream) on this page.

## Time series overview

A time series is a sequence of observations for a specific entity. Together, these observations let you track changes to the entity over time. For example, a time series can track:
- CPU and disk usage for a computer
- The price of a stock
- Temperature and humidity readings from a weather sensor

![time series chart](https://www.elastic.co/docs/manage-data/images/elasticsearch-reference-time-series-chart2.svg)


### Time series fields

Compared to a regular data stream, a TSDS uses some additional fields specific to time series: dimension fields and metric fields, plus an internal `_tsid` metadata field.

#### Dimensions

Dimension fields often correspond to characteristics of the items you're measuring. For example, documents related to the same weather sensor might have the same `sensor_id` and `location` values.
<tip>
  Elasticsearch uses dimensions and timestamps to generate time series document `_id` values. Two documents with the same dimensions and timestamp are considered duplicates. Duplicates are rejected during ingestion with a `409 Conflict` status.
</tip>

To mark a field as a dimension, set the Boolean `time_series_dimension` mapping parameter to `true`. The following field types support the `time_series_dimension` parameter:
- [`keyword`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/keyword#keyword-field-type)
- [`ip`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/ip)
- [`byte`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/number)
- [`short`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/number)
- [`integer`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/number)
- [`long`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/number)
- [`unsigned_long`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/number)
- [`boolean`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/boolean)

To work with a flattened field, use the `time_series_dimensions` parameter to configure an array of fields as dimensions. For details, refer to [`flattened`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/flattened#flattened-params).
You can also simplify dimension definitions by using [pass-through](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/passthrough#passthrough-dimensions) fields.

#### Metrics

Metrics are numeric measurements that change over time. Documents in a TSDS typically contain one or more metric fields.
To mark a field as a metric, use the `time_series_metric` mapping parameter. This parameter ensures data is stored in an optimal way for time series analysis. The valid values for `time_series_metric` are `counter`, `gauge` and `histogram`:
<definitions>
  <definition term="counter">
    A cumulative metric that only monotonically increases or resets to `0` (zero). For example, a count of errors or completed tasks that resets when a serving process restarts. A counter is supported by all [numeric field types](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/number)
  </definition>
  <definition term="gauge">
    A metric that represents a single numeric that can arbitrarily increase or decrease. For example, a temperature or available disk space. A gauge is supported by all [numeric field types](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/number) and [`aggregate_metric_double`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/aggregate-metric-double) (for internal use during downsampling, rarely user-populated).
  </definition>
  <definition term="histogram Elastic Stack: Preview since 9.3 Elastic Cloud Serverless: Preview">
    A metric that tracks the distribution of numerical values, like latency or size distributions. A histogram is supported by [`histogram`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/histogram) and [`exponential_histogram`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/exponential-histogram).
  </definition>
</definitions>


#### `_tsid` metadata field

The `_tsid` is an automatically generated object derived from the document’s dimensions. It's intended for internal Elasticsearch use, so in most cases you won't need to work with it. The format of the `_tsid` field is subject to change.

### Differences from a regular data stream

A time series data stream works like a regular data stream, with some key differences:
- **Time series index mode:** The matching index template for a TSDS must include a `data_stream` object with `index.mode` set to `time_series`. This option enables most TSDS-related functionality.
- **Fields:** In a TSDS, each document contains:
  - A `@timestamp` field
- One or more [dimension fields](#time-series-dimension), set with `time_series_dimension: true`
- One or more [metric fields](#time-series-metric)
- An auto-generated document `_id` (custom `_id` values are not supported)
- **Backing indices:** A TSDS uses [time-bound indices](https://www.elastic.co/docs/manage-data/data-store/data-streams/time-bound-tsds) to store data from the same time period in the same backing index.
- **Dimension-based routing:** The routing logic uses dimension fields to map all data points of a time series to the same shard, improving storage efficiency and query performance. Duplicate data points are rejected.
- **Sorting:** A TSDS uses internal [index sorting](https://www.elastic.co/docs/reference/elasticsearch/index-settings/sorting) to order shard segments by `_tsid` and `@timestamp`, for better compression. Time series data streams do not use `index.sort.*` settings.
- **Source field:** A TSDS uses [synthetic `_source`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-source-field#synthetic-source), and as a result is subject to some [restrictions](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-source-field#synthetic-source-restrictions) and [modifications](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-source-field#synthetic-source-modifications) applied to the `_source` field.
- <applies-to>Elastic Stack: Generally available since 9.3</applies-to> **Doc value Skippers:** A TSDS enables [docvalue skippers](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/doc-values#doc-values-skippers) on its `_tsid`, `@timestamp`, [dimension](#time-series-dimension), and [metric](#time-series-metric) fields. Because `tsid` and `@timestamp` are part of the index sort, the skippers allow Elasticsearch to avoid building backing indexes for these fields, meaning lower disk usage and faster ingest speed.


## Query time series data

<applies-to>
  - Elastic Cloud Serverless: Preview
</applies-to>

You can use the ES|QL [`TS` command](https://www.elastic.co/docs/reference/query-languages/esql/commands/ts) to query time series data streams. The `TS` command is optimized for time series data. It also enables the use of aggregation functions that efficiently process metrics per time series, before aggregating results.

## Next steps

- Try the [quickstart](https://www.elastic.co/docs/manage-data/data-store/data-streams/quickstart-tsds) for a hands-on introduction
- [Set up a time series data stream](https://www.elastic.co/docs/manage-data/data-store/data-streams/set-up-tsds)
- [Ingest data using the OpenTelemetry Protocol (OTLP)](https://www.elastic.co/docs/manage-data/data-store/data-streams/tsds-ingest-otlp)
- Learn about [downsampling](https://www.elastic.co/docs/manage-data/data-store/data-streams/downsampling-time-series-data-stream) to reduce storage footprint