﻿---
title: Reindex a time series data stream
description: Reindexing allows you to copy documents from an existing time series data stream (TSDS) to a new one. All data streams support reindexing, but time series...
url: https://www.elastic.co/docs/manage-data/data-store/data-streams/reindex-tsds
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Reindex a time series data stream
Reindexing allows you to copy documents from an existing [time series data stream (TSDS)](https://www.elastic.co/docs/manage-data/data-store/data-streams/time-series-data-stream-tsds) to a new one. All data streams support reindexing, but time series data streams require special handling due to their time-bound backing indices and strict timestamp acceptance windows.
<important>
  When you reindex, the result is a single backing index of a new data stream.
</important>

To reindex, follow the steps on this page.
<note>
  This process only applies to time series data streams without a [downsampling](https://www.elastic.co/docs/manage-data/data-store/data-streams/downsampling-time-series-data-stream) configuration. To reindex a downsampled data stream, reindex the backing indices individually, then add them to a new, empty data stream.
</note>


## Overview

These high-level steps summarize the process of reindexing a time series data stream. Each step is detailed in a later section.
1. Create an index template for the destination data stream
2. Update the template with temporary settings for reindexing
3. Run the reindex operation
4. Revert the temporary index settings
5. Perform a manual rollover to create a new backing index for incoming data

The examples on this page use Dev Tools [Console](https://www.elastic.co/docs/explore-analyze/query-filter/tools/console) syntax.

## Create the destination index template

Create an index template for the new TSDS, using your preferred mappings and settings:
```json

{
  "index_patterns": ["my-new-tsds"],
  "priority": 100,
  "data_stream": {},
  "template": {
    "settings": {
      "index.mode": "time_series"
    },
    "mappings": {
      "properties": {
        "@timestamp": {
          "type": "date"
        },
        "dimension_field": {
          "type": "keyword",
          "time_series_dimension": true
        },
        "metric_field": {
          "type": "double",
          "time_series_metric": "gauge"
        }
      }
    }
  }
}
```


## Update the template for reindexing

To support the reindexing process, you need to temporarily modify the template:
1. Set `index.time_series.start_time` and `index.time_series.end_time` index settings to match the lowest and highest `@timestamp` values in the old data stream.
2. Set `index.number_of_shards` to the sum of all primary shards of all backing indices of the old data stream.
3. Clear the `index.lifecycle.name` index setting (if any), to prevent ILM from modifying the destination data stream during reindexing.
4. (Optional) Set `index.number_of_replicas` to zero, to speed up reindexing. Because the data gets copied in the reindexing process, you don't need replicas.

```json

{
  "index_patterns": ["new-tsds*"],
  "priority": 100,
  "data_stream": {},
  "template": {
    "settings": {
      "index.mode": "time_series",
      "index.routing_path": ["host", "service"], 
      "index.time_series.start_time": "2023-01-01T00:00:00Z", <1>
      "index.time_series.end_time": "2025-01-01T00:00:00Z",  <2>
      "index.number_of_shards": 6, <3>
      "index.number_of_replicas": 0, <4>
      "index.lifecycle.name": null  <5>
    },
    "mappings": {
      ...
    }
  }
}
```


### Create the destination data stream and reindex

Run the reindex operation:
```json

{
  "source": {
    "index": "old-tsds"
  },
  "dest": {
    "index": "new-tsds",
    "op_type": "create"
  }
}
```


## Restore the destination index template

After reindexing completes, update the index template again to remove the temporary settings:
- Remove the overrides for `index.time_series.start_time` and `index.time_series.end_time`.
- Restore the values of `index.number_of_shards`, `index.number_of_replicas`,  and  `index.lifecycle.name` (as applicable).

```json

{
  "index_patterns": ["new-tsds*"],
  "priority": 100,
  "data_stream": {},
  "template": {
    "settings": { 
      "index.mode": "time_series",
      "index.routing_path": ["host", "service"],
      "index.number_of_replicas": 1, <1>
      "index.lifecycle.name": "my-ilm-policy" <2>
    }, 
    "mappings": {
      ...
    }
  }
}
```


## Roll over for new data

Create a new backing index with a manual rollover request:
```json
```

The destination data stream is now ready to accept new documents.

## Related resources

- [Time series data streams overview](https://www.elastic.co/docs/manage-data/data-store/data-streams/time-series-data-stream-tsds)
- [Reindex API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-reindex)