﻿---
title: Querying downsampled data
description: To query a downsampled index, use the _search and _async_search endpoints. You can query multiple raw data and downsampled indices in a single request,...
url: https://www.elastic.co/docs/manage-data/data-store/data-streams/query-downsampled-data
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Querying downsampled data
To query a downsampled index, use the [`_search`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search) and [`_async_search`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-async-search-submit) endpoints.
- You can query multiple raw data and downsampled indices in a single request, and a single request can include downsampled indices with multiple downsampling intervals (for example, `15m`, `1h`, `1d`).
- When you run queries in Kibana and through Elastic solutions, a standard response is returned, with no indication that some of the queried indices are downsampled.
- [Date histogram aggregations](https://www.elastic.co/docs/reference/aggregations/search-aggregations-bucket-datehistogram-aggregation) support `fixed_intervals` only (not calendar-aware intervals).
- Time-based histogram aggregations use a uniform bucket size, without regard to the downsampling time interval specified in the request.


## Time zone offsets

Date histograms are based on UTC values. Some time zone situations require offsetting (shifting the time buckets) when downsampling:
- For time zone `+5:30` (India), offset by 30 minutes -- for example, `2020-01-01T10:30:00.000` instead of `2020-03-07T10:00:00.000`. Or use a downsampling interval of 15 minutes instead of offsetting.
- For intervals based on days rather than hours, adjust the buckets to the appropriate time zone -- for example, `2020-03-07T19:00:00.000` instead of `2020-03-07T00:00:00.000` for `America/New_York`.

When offsetting is applied, responses include the field `downsampled_results_offset: true`.
For more details, refer to [Date histogram aggregation: Time zone](https://www.elastic.co/docs/reference/aggregations/search-aggregations-bucket-datehistogram-aggregation#datehistogram-aggregation-time-zone).

## ES|QL `TS` command

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.2
</applies-to>

You can use the ES|QL [`TS` command](https://www.elastic.co/docs/reference/query-languages/esql/commands/ts) to query time series data streams. The `TS` command is optimized for time series data. It also enables the use of aggregation functions that efficiently process metrics per time series, before aggregating results.