﻿---
title: Manage a data stream
description: Investigate your data streams and address lifecycle management needs in the Data Streams view. The value in the Indices column indicates the number of...
url: https://www.elastic.co/docs/manage-data/data-store/data-streams/manage-data-stream
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Manage a data stream
Investigate your data streams and address lifecycle management needs in the **Data Streams** view.
The value in the **Indices** column indicates the number of backing indices. Click this number to drill down into details.
A value in the data retention column indicates that the data stream is managed by a data stream lifecycle policy. This value is the time period for which your data is guaranteed to be stored. Data older than this period can be deleted by Elasticsearch at a later time.
In Elasticsearch Serverless, indices matching the `logs-*-*` pattern use the logsDB index mode by default. The logsDB index mode creates a [logs data stream](https://www.elastic.co/docs/manage-data/data-store/data-streams/logs-data-stream).
![Data stream details](https://www.elastic.co/docs/manage-data/images/serverless-management-data-stream.png)

- To view more information about a data stream, such as its generation or its current index lifecycle policy, click the stream’s name. From this view, you can navigate to **Discover** to further explore data within the data stream.
- To view information about the stream’s backing indices, click the number in the **Indices** column.
- To modify the data retention value, select a data stream, open the **Manage**  menu, and click **Edit data retention**.


## Manage data streams on the Streams page

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.2
  - Elastic Stack: Preview in 9.1
</applies-to>

The [**Streams**](https://www.elastic.co/docs/solutions/observability/streams/streams) page provides a centralized interface for managing your data in Kibana. It consolidates common data management tasks and eliminates the need for manual configuration of multiple applications and components. A stream maps directly to an Elasticsearch data stream, for example `logs-myapp-default`. Any changes that you make on the **Streams** page are automatically propagated to the associated data stream.
![The Streams page](https://www.elastic.co/docs/manage-data/images/data-stream-management-streams.png)

You can perform the following data management tasks on the **Streams** page:
- [define parsing and field extraction logic](https://www.elastic.co/docs/solutions/observability/streams/management/extract)
- [configure data retention policies](https://www.elastic.co/docs/solutions/observability/streams/management/retention)
- [manually adjust index settings](https://www.elastic.co/docs/solutions/observability/streams/management/advanced)
- [manage and update field mappings](https://www.elastic.co/docs/solutions/observability/streams/management/schema)
- [identify failed and degraded documents](https://www.elastic.co/docs/solutions/observability/streams/management/data-quality)
- [partition data into child streams](https://www.elastic.co/docs/solutions/observability/streams/management/partitioning) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>