﻿---
title: Downsampling concepts
description: This page explains core downsampling concepts. A time series is a sequence of observations taken over time for a specific entity. The observed samples...
url: https://www.elastic.co/docs/manage-data/data-store/data-streams/downsampling-concepts
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Downsampling concepts
This page explains core downsampling concepts.
<important>
  Downsampling works with [time series data streams](https://www.elastic.co/docs/manage-data/data-store/data-streams/time-series-data-stream-tsds) only.
</important>

A [time series](/docs/manage-data/data-store/data-streams/time-series-data-stream-tsds#time-series) is a sequence of observations taken over time for a specific entity. The observed samples can be represented as a continuous function, where the time series dimensions remain constant and the time series metrics change over time.
![time series function](https://www.elastic.co/docs/manage-data/images/elasticsearch-reference-time-series-function.png)

In a time series data stream, a single document is created for each timestamp. The document contains the immutable time series dimensions, plus metric names and values. Several time series dimensions and metrics can be stored for a single timestamp.
![time series metric anatomy](https://www.elastic.co/docs/manage-data/images/elasticsearch-reference-time-series-metric-anatomy.png)

For the most current data, the metrics series typically has a low sampling time interval to optimize for queries that require a high data resolution.
![time series original](https://www.elastic.co/docs/manage-data/images/elasticsearch-reference-time-series-original.png)

_Downsampling_ reduces the footprint of older, less frequently accessed data by replacing the original time series with a data stream of a higher sampling interval, plus statistical representations of the data. For example, if the original metrics samples were taken every 10 seconds, you might choose to reduce the sample granularity to hourly as the data ages. Or you might choose to reduce the granularity of `cold` archival data to monthly or less.
![time series downsampled](https://www.elastic.co/docs/manage-data/images/elasticsearch-reference-time-series-downsampled.png)


## How downsampling works

Downsampling is applied to the individual backing indices of the TSDS. The downsampling operation traverses the source time series index and performs the following steps:
1. Creates a new document for each group of documents with  matching `_tsid` values (time series dimension fields), grouped into buckets that correspond to timestamps in a specific interval.
   For example, a TSDS index that contains metrics sampled every 10 seconds can be downsampled to an hourly index. All documents within a given hour interval are summarized and stored as a single document in the downsampled index.
2. For each new document, copies all [time series dimensions](/docs/manage-data/data-store/data-streams/time-series-data-stream-tsds#time-series-dimension) from the source index to the target index. Dimensions in a TSDS are constant, so this step happens only once per bucket.
3. For each [time series metric](/docs/manage-data/data-store/data-streams/time-series-data-stream-tsds#time-series-metric) field, it computes the downsampled values based on the [downsampling method](#downsampling-methods).
4. For all other fields, copies the most recent value to the target index.
5. Replaces the original index with the downsampled index, then deletes the original index.

The new, downsampled index is created on the data tier of the original index and inherits the original settings, like number of shards and replicas.
<tip>
  You can downsample a downsampled index. The subsequent downsampling interval must be a multiple of the interval used in the preceding downsampling operation.
</tip>


### Downsampling methods

The downsampling method is the technique used to reduce multiple values within the same bucket into a single representative value. Two distinct methods exist:
- `last_value`: <applies-to>Elastic Stack: Preview since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Generally available</applies-to>
  This method increases the sampling interval by storing only the most recent value for each metric in the same bucket. While this reduces data accuracy, it offers the benefit of conserving storage space. It applies to all metric types.
- `aggregate`:
  This method preserves data accuracy by computing and storing statistical aggregations for all documents within the bucket, though it requires more storage space. It applies to each metric type in the following way:
  - `gauge` field type:
  - `min`, `max`, `sum`, and `value_count` are stored as type `aggregate_metric_double`.
- `counter` field type:
  - the last value is stored and the type is preserved.
- `histogram` field type: <applies-to>Elastic Stack: Preview since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - individual histograms are merged into a single histogram that is stored, preserving the type. The `histogram` field type uses the [T-Digest](https://www.elastic.co/docs/reference/aggregations/search-aggregations-metrics-percentile-aggregation) algorithm.

<tip>
  When downsampling a downsampled index, use the same downsampling method as the source index.
</tip>


### Source and target index field mappings

Fields in the target downsampled index are created with the same mapping as in the source index, with one exception: `time_series_metric: gauge` fields are changed to `aggregate_metric_double`.