﻿---
title: Solutions overview
description: Elastic offers three major search-powered solutions: Elasticsearch, Elastic Observability, and Elastic Security—all built on an open source, extensible...
url: https://www.elastic.co/docs/get-started/introduction
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Solutions overview
Elastic offers three major search-powered solutions: Elasticsearch, Elastic Observability, and Elastic Security—all built on an open source, extensible [platform](https://www.elastic.co/docs/get-started/the-stack).
Whether you're building a search experience, monitoring your infrastructure, or securing your environment, there is a solution that is right for your business needs.

| Your need                                                                                                                | Recommended solution                                                                                                                                         | Best for                                         |
|--------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------|
| Build powerful, scalable searches to quickly search, analyze, and visualize large amounts of data for real-time insights | [Elasticsearch](https://www.elastic.co/docs/solutions/search)• [Get started](https://www.elastic.co/docs/solutions/search/get-started)                       | Developers, architects, data engineers           |
| Observe and monitor system health and performance, or send telemetry data                                                | [Elastic Observability](https://www.elastic.co/docs/solutions/observability)• [Get started](https://www.elastic.co/docs/solutions/observability/get-started) | DevOps, SREs, IT operations                      |
| Monitor data for anomalous activity, detect, prevent, and respond to security incidents                                  | [Elastic Security](https://www.elastic.co/docs/solutions/security)• [Get started](https://www.elastic.co/docs/solutions/security/get-started)                | SOC teams, security analysts, IT security admins |

<note>
  The core [Elasticsearch search capabilities](https://www.elastic.co/docs/solutions/search) are available across all deployment types, solutions, and project types. The [Elasticsearch solution](https://www.elastic.co/docs/solutions/elasticsearch-solution-project) adds UI tools on top of these capabilities to help you build search-powered applications faster.
</note>

<tip>
  Check out our [customer success stories](https://www.elastic.co/customers/success-stories) to learn how various organizations utilize our products for their specific business needs.
</tip>

Each of our solutions is available as a fully managed Serverless project, a managed service on Elastic Cloud Hosted, or a self-managed deployment. Refer to [deployment options](https://www.elastic.co/docs/get-started/deployment-options) to learn about these options.
If you're new to Elastic, you can find quickstarts and introductory steps for each solution within [Solutions and use cases](https://www.elastic.co/docs/solutions).