﻿---
title: How to use the documentation
description: Our documentation is organized to guide you through your journey with Elastic, from learning the basics to deploying and managing complex solutions. Here...
url: https://www.elastic.co/docs/get-started/howto-use-the-docs
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# How to use the documentation
Our documentation is organized to guide you through your journey with Elastic, from learning the basics to deploying and managing complex solutions.
Here is a detailed breakdown of the documentation structure:
- [**Elastic fundamentals**](https://www.elastic.co/docs/get-started): Understand the basics about the deployment options, platform, solutions, and features of the documentation.
- [**Solutions and use cases**](https://www.elastic.co/docs/solutions): Learn use cases, evaluate, and implement Elastic's solutions: Observability, Search, and Security.
- [**Manage data**](https://www.elastic.co/docs/manage-data): Learn about data store primitives, ingestion and enrichment, managing the data lifecycle, and migrating data.
- [**Explore and analyze**](https://www.elastic.co/docs/explore-analyze): Get value from data through querying, visualization, machine learning, and alerting.
- [**Deploy and manage**](https://www.elastic.co/docs/deploy-manage): Deploy and manage production-ready clusters. Covers deployment options and maintenance tasks.
- [**Manage your Cloud account**](https://www.elastic.co/docs/cloud-account): A dedicated section for user-facing cloud account tasks like resetting passwords.
- [**Troubleshoot**](https://www.elastic.co/docs/troubleshoot): Identify and resolve problems.
- [**Extend and contribute**](https://www.elastic.co/docs/extend): How to contribute to or integrate with Elastic, from open source to plugins to integrations.
- [**Release notes**](https://www.elastic.co/docs/release-notes): Contains release notes and changelogs for each new release.
- [**Reference**](https://www.elastic.co/docs/reference): Reference material for core tasks and manuals for other Elastic products.


## Applicability badges

Because you can deploy Elastic products in different ways and have different versions, not all documentation applies to every user. To help you quickly see if a topic is relevant to your situation, we use **applicability badges**.
These badges appear at the top of a page or section and tell you which products, deployment models, and versions the content applies to. They also indicate the maturity level of a feature. This system ensures that you can identify content specific to your environment and version.
To learn more about how applicability badges work and how they're used in our cumulative documentation system, refer to [Write cumulative documentation](https://www.elastic.co/docs/contribute-docs/how-to/cumulative-docs) and [Badge usage and placement](https://www.elastic.co/docs/contribute-docs/how-to/cumulative-docs/badge-placement).
<tip>
  A **Stack** badge indicates that a page applies to [Elastic Stack](https://www.elastic.co/docs/get-started/the-stack) components across all deployment options except Elastic Cloud Serverless. If a page applies to all deployment options, it has **Serverless** and **Stack** badges.
</tip>


## Page options

On each documentation page, you can find several links that allow you to interact with the content:
- **View as Markdown**: This link shows you the raw Markdown source code for the page you're viewing. This can be helpful if you want to reuse the source or feed the document to AI.
- **Edit this page**: Selecting this link will take you directly to the page's source file in its GitHub repository. From there, you can propose edits, which our team will review.
- **Report an issue**: If you've found a problem, like a typo, a technical error, or confusing content, but don't want to edit the page yourself, use this link. It will open a new issue in our GitHub repository, pre-filled with information about the page you were on, so you can describe the problem in detail.


## Versioned documentation

Starting with Elastic Stack 9.0, Elastic no longer publishes separate documentation sets for each minor release. Instead, all changes in the 9.x series are included in a single, continuously updated documentation set.
Read more in [Versioning and availability](https://www.elastic.co/docs/get-started/versioning-availability).

## Accessing previous versions

You can browse documentation for different versions of our products in two ways:
- **Version menu:** On most documentation pages, you'll find a version menu. Clicking this menu allows you to switch to a different version of the documentation for the content you are currently viewing.
- **All documentation versions page:** For a complete list of all available documentation versions for all Elastic products, you can visit the [All documentation versions](https://www.elastic.co/docs/versions) page.


## Glossary

To help you understand the terminology used throughout our documentation, we provide a [glossary of common Elastic terms](https://www.elastic.co/docs/reference/glossary). This is a great resource for new users or anyone looking to clarify the meaning of a specific term.

## How to contribute

We value contributions from our community. For detailed instructions on how to contribute to both the main documentation and the API references, refer to our [contribution guide](https://www.elastic.co/docs/extend/contribute/).