﻿---
title: Elastic fundamentals
description: Learn the fundamentals of Elastic. Discover what Elastic offers, explore core concepts of the Elastic Stack, understand deployment options, and access training resources to get started.
url: https://www.elastic.co/docs/get-started
products:
  - Elastic Observability
  - Elastic Security
  - Elastic Stack
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Elastic fundamentals
Welcome to Elastic fundamentals. This section helps you understand our platform, learn core concepts, and explore deployment options.
<tip>
  If you are using a [free 14-day Elastic Cloud trial](https://cloud.elastic.co/registration?page=docs&placement=docs-body) and need guidance on building a proof of concept, refer to [Evaluate Elastic during a trial](https://www.elastic.co/docs/get-started/evaluate-elastic).
</tip>

In this section, we'll walk you through the basics of what our products offer, what they do, how they can help your business, and how to set them up. You'll get a quick look at the core features and concepts, real-world use cases, and deployment options to understand how everything fits together.
You'll also find other helpful information, such as how to use our docs, training resources, and a link to our glossary so you can familiarize yourself with our terminology.

## What is Elastic?

![The Elastic platform](https://www.elastic.co/docs/get-started/images/elastic-platform.png)

Elastic provides an open source search, analytics, and AI platform, and out-of-the-box solutions for observability and security. The Search AI platform combines the power of search and generative AI to provide near real-time search and analysis with relevance to reduce your time to value.

## Explore the fundamentals

Continue your journey with these essential guides that will help you understand and work with Elastic:
- **[Solutions overview](https://www.elastic.co/docs/get-started/introduction)**: Get an introduction to the Elasticsearch, Elastic Observability, and Elastic Security solutions and projects.
- **[The Elastic Stack](https://www.elastic.co/docs/get-started/the-stack)**: Dive deeper into how the Elastic Stack—our suite of open-source tools, including Elasticsearch, Kibana, Beats, and Logstash—components work together. Learn about data ingestion methods and understand the core concepts of storing, visualizing, and querying your data.
- **[Deployment options](https://www.elastic.co/docs/get-started/deployment-options)**: Explore the different ways you can deploy Elastic, from fully managed serverless solutions to self-managed installations, and choose the approach that best fits your operational needs.
- **[Versioning and availability](https://www.elastic.co/docs/get-started/versioning-availability)**: Learn how Elastic handles versioning, understand feature availability across different deployment types, and navigate our continuously updated documentation with confidence.


## Training resources

Whether you are just getting started with Elastic, an expert, or simply want to expand your knowledge, we provide role-based and solution-based training to empower you to get the most out of our solutions. You can even receive accreditation for completing our courses.
Ready to dive in? Check out [[https://www.elastic.co/training](https://www.elastic.co/training)](https://www.elastic.co/training) to browse our virtual and on-demand training courses. If you're unsure where to start, check out the [Elasticsearch Engineer](https://www.elastic.co/training/elasticsearch-engineer) course.
To explore particular, more granular facets of the Elastic Stack, check out our [demo gallery](https://www.elastic.co/demo-gallery). You can filter by solution or subject area and choose the training style that best suits you.
If you prefer a deep dive where you can learn at your own pace, check out our six-part [Beginner's Crash Course to Elastic Stack](https://www.youtube.com/playlist?list=PL_mJOmq4zsHZYAyK606y7wjQtC0aoE6Es) on YouTube.

## Other resources

Check out these additional resources to learn and explore other areas of Elastic:
- **[Deploy and manage](https://www.elastic.co/docs/deploy-manage)**: Learn how to deploy and manage all aspects of your Elastic environment.
- **[Manage data](https://www.elastic.co/docs/manage-data)**: Learn how to ingest and manage data stored in Elasticsearch.
- **[How to use the documentation](https://www.elastic.co/docs/get-started/howto-use-the-docs)**: Understand how our documentation is organized, find the right version information for your products, and learn how to contribute.