﻿---
title: Document your plugin
description: Documentation is a required component of your plugin. Quality documentation with good examples contributes to the adoption of your plugin. The documentation...
url: https://www.elastic.co/docs/extend/logstash/plugin-doc
products:
  - Logstash
---

# Document your plugin
Documentation is a required component of your plugin. Quality documentation with good examples contributes to the adoption of your plugin.
The documentation that you write for your plugin will be generated and published in the [Logstash Reference](https://www.elastic.co/docs/reference/logstash) and the [Logstash Versioned Plugin Reference](https://www.elastic.co/docs/reference/logstash/versioned-plugins/integration-plugins).
<admonition title="Plugin listing in Logstash Reference">
  We may list your plugin in the [Logstash Reference](https://www.elastic.co/docs/reference/logstash) if it meets our [requirements and quality standards](/docs/extend/logstash#plugin-acceptance). When we list your plugin, we point to *your* documentation—a readme.md, docs/index.asciidoc, or both—in your plugin repo. For more info on this option, see [List your plugin](https://www.elastic.co/docs/extend/logstash/plugin-listing).
</admonition>

The following sections contain guidelines for documenting plugins hosted in the Github [logstash-plugins](https://github.com/logstash-plugins/) organization.

## Documentation file

Documentation belongs in a single file called *docs/index.asciidoc*. It belongs in a single file called *docs/index.asciidoc*. The [plugin generation utility](https://www.elastic.co/docs/reference/logstash/plugin-generator) creates a starter file for you.

## Heading IDs

Format heading anchors with variables that can support generated IDs. This approach creates unique IDs when the [Logstash Versioned Plugin Reference](https://www.elastic.co/docs/reference/logstash/versioned-plugins/integration-plugins) is built. Unique heading IDs are required to avoid duplication over multiple versions of a plugin.
**Example**
Don’t hardcode a plugin heading ID like this: `[[config_models]]`
Instead, use variables to define it:
```txt
[id="plugins-{type}s-{plugin}-config_models"]
==== Configuration models
```

If you hardcode an ID, the [Logstash Versioned Plugin Reference](https://www.elastic.co/docs/reference/logstash/versioned-plugins/integration-plugins) builds correctly the first time. The second time the doc build runs, the ID is flagged as a duplicate, and the build fails.

## Link formats

Correct link formatting is essential for directing users to the content you want them to see. Incorrect link formatting or duplicate links can break the documentation build. Let’s not do that.

### Link to content in the same file

Use angle brackets to format links to content in the same asciidoc file.
**Example**
This link:
```txt
<<plugins-{type}s-{plugin}-config_models>>
```

Points to this heading in the same file:
```txt
[id="plugins-{type}s-{plugin}-config_models"]
==== Configuration models
```


### Link to content in the Logstash Reference Guide

Use external link syntax for links that point to documentation for other plugins or content in the Logstash Reference Guide.
**Examples**
```txt
{logstash-ref}/plugins-codecs-multiline.html[Multiline codec plugin]
```

```txt
{logstash-ref}/getting-started-with-logstash.html
```


### Link text

If you don’t specify link text, the URL is used as the link text.
**Examples**
If you want your link to display as https://www.elastic.co/guide/en/logstash/current/getting-started-with-logstash.html, use this format:
```txt
{logstash-ref}/getting-started-with-logstash.html
```

If you want your link to display as [Getting Started with Logstash](https://www.elastic.co/docs/reference/logstash/getting-started-with-logstash), use this format:
```txt
{logstash-ref}/getting-started-with-logstash.html[Getting Started with Logstash]
```


### Link to data type descriptions

We make an exception for links that point to data type descriptions, such as `<<boolean,boolean>>`, because they are used so frequently. We have a cleanup step in the conversion script that converts the links to the correct syntax.

## Code samples

We all love code samples. Asciidoc supports code blocks and config examples. To include Ruby code, use the asciidoc `[source,ruby]` directive.
Note that the hashmarks (#) are present to make the example render correctly. Don’t include the hashmarks in your asciidoc file.
```txt
# [source,ruby]
# -----
# match => {
#  "field1" => "value1"
#  "field2" => "value2"
#  ...
# }
# -----
```

The sample above (with hashmarks removed) renders in the documentation like this:
```ruby
match => {
  "field1" => "value1"
  "field2" => "value2"
  ...
}
```


## Where’s my doc?

Plugin documentation goes through several steps before it gets published in the [Logstash Versioned Plugin Reference](https://www.elastic.co/docs/reference/logstash/versioned-plugins/integration-plugins) and the [Logstash Reference](https://www.elastic.co/docs/reference/logstash).
Here’s an overview of the workflow:
- Be sure that you have signed the contributor license agreement (CLA) and have all necessary approvals and sign offs.
- Merge the pull request for your plugin (including the `index.asciidoc` file, the `changelog.md` file, and the gemspec).
- Wait for the continuous integration build to complete successfully.
- Publish the plugin to [[https://rubygems.org](https://rubygems.org)](https://rubygems.org).
- A script detects the new or changed version, and picks up the `index.asciidoc` file for inclusion in the doc build.
- The documentation for your new plugin is published in the [Logstash Versioned Plugin Reference](https://www.elastic.co/docs/reference/logstash/versioned-plugins/integration-plugins).

We’re not done yet.
- For each release, we package the new and changed documentation files into a pull request to add or update content. (We sometimes package plugin docs between releases if we make significant changes to plugin documentation or add a new plugin.)
- The script detects the new or changed version, and picks up the `index.asciidoc` file for inclusion in the doc build.
- We create a pull request, and merge the new and changed content into the appropriate version branches.
- For a new plugin, we add a link to the list of plugins in the [Logstash Reference](https://www.elastic.co/docs/reference/logstash).
- The documentation for your new (or changed) plugin is published in the [Logstash Reference](https://www.elastic.co/docs/reference/logstash).


### Documentation or plugin updates

When you make updates to your plugin or the documentation, consider bumping the version number in the changelog and gemspec (or version file). The version change triggers the doc build to pick up your changes for publishing.

## Resources

For more asciidoc formatting tips, see the excellent reference at [[https://github.com/elastic/docs#asciidoc-guide](https://github.com/elastic/docs#asciidoc-guide)](https://github.com/elastic/docs#asciidoc-guide).
For tips on contributing and changelog guidelines, see [CONTRIBUTING.md](https://github.com/elastic/logstash/blob/main/CONTRIBUTING.md#logstash-plugin-changelog-guidelines).
For general information about contributing, see [Contributing to Logstash](https://www.elastic.co/docs/extend/logstash).