﻿---
title: Running Elasticsearch during development
description: There are many ways to run Elasticsearch while you are developing. This will run a snapshot of Elasticsearch that is usually built nightly. Snapshot status...
url: https://www.elastic.co/docs/extend/kibana/running-elasticsearch
products:
  - Kibana
---

# Running Elasticsearch during development
There are many ways to run Elasticsearch while you are developing.

### By snapshot

This will run a snapshot of Elasticsearch that is usually built nightly. Snapshot status is available on the [dashboard](https://ci.kibana.dev/es-snapshots).
```bash
yarn es snapshot
```

By default, two users are added to Elasticsearch:
- A superuser with username: `elastic` and password: `changeme`, which can be used to log into Kibana with.
- A user with username: `kibana_system` and password `changeme`. This account is used by the Kibana server to authenticate itself to Elasticsearch, and to perform certain actions on behalf of the end user. These credentials should be specified in your kibana.yml as described in [Configure security](https://www.elastic.co/docs/deploy-manage/security/secure-your-cluster-deployment)

See all available options, like how to specify a specific license, with the `--help` flag.
```bash
yarn es snapshot --help
```

`--license trial` will give you access to all capabilities.
**Keeping data between snapshots**
If you want to keep the data inside your Elasticsearch between usages of this command, you should use the following command, to keep your data folder outside the downloaded snapshot folder:
```bash
yarn es snapshot -E path.data=../data
```


## By source

If you have the Elasticsearch repo checked out locally and wish to run against that, use `source`. By default, it will reference an Elasticsearch checkout which is a sibling to the Kibana directory named elasticsearch. If you wish to use a checkout in another location you can provide that by supplying --source-path
```bash
yarn es source
```


## From an archive

Use this if you already have a distributable. For released versions, one can be obtained on the Elasticsearch downloads page.
```bash
yarn es archive <full_path_to_archive>
```

Each of these will run Elasticsearch with a basic license. Additional options are available, pass --help for more information.

## From a remote host

You can save some system resources, and the effort of generating sample data, if you have a remote Elasticsearch cluster to connect to. (Elasticians: you do! Check with your team about where to find credentials)
You’ll need to create a kibana.dev.yml ([Customizing `config/kibana.dev.yml`](/docs/extend/kibana/running-kibana-advanced#customize-kibana-yml)) and add the following to it:
```bash
elasticsearch.hosts:
  - {{ url }}
elasticsearch.username: {{ username }}
elasticsearch.password: {{ password }}
elasticsearch.ssl.verificationMode: none
```


### Running remote clusters

Setup remote clusters for cross cluster search (CCS) and cross cluster replication (CCR).
Start your primary cluster by running:
```bash
yarn es snapshot -E path.data=../data_prod1
```

Start your remote cluster by running:
```bash
yarn es snapshot -E transport.port=9500 -E http.port=9201 -E path.data=../data_prod2
```

Once both clusters are running, start Kibana. Kibana will connect to the primary cluster.
Setup the remote cluster in Kibana from either Management → Elasticsearch → Remote Clusters UI or by running the following script in Console.
```bash
PUT _cluster/settings
{
  "persistent": {
    "cluster": {
      "remote": {
        "cluster_one": {
          "seeds": [
            "localhost:9500"
          ]
        }
      }
    }
  }
}
```

Follow the cross-cluster search instructions for setting up index patterns to search across clusters ([Use data views with cross-cluster search](https://www.elastic.co/docs/explore-analyze/find-and-organize/data-views#management-cross-cluster-search)).