﻿---
title: Reporting integration
description: Applications abide by a contract that reporting features use to determine the information that is required to request exports of data from Kibana, and...
url: https://www.elastic.co/docs/extend/kibana/reporting-integration
products:
  - Kibana
---

# Reporting integration
Applications abide by a contract that reporting features use to determine the information that is required to request exports of data from Kibana, and how to generate and store the reports.
<important>
  These pages document internal APIs and are not guaranteed to be supported across future versions of Kibana. However, these docs will be kept up-to-date to reflect the current implementation of Reporting integration in Kibana.
</important>


### Reporting Export Types

"Export Types" are pieces of code that plug into the Kibana Reporting framework, and are responsible for exporting data on behalf of a Kibana application. These pieces of code are implemented as TypeScript classes that extend an abstract base class, and implement methods for controlling the creation of report jobs, and asynchronously generating report contents. Their `createJob` methods handle requests to create report jobs, by accepting jobParams objects and returning "task payload" objects. Their `runTask` methods generate the report contents by accepting the task payload object created from the `createJob` function, which is then stored in a system index in Elasticsearch.

### Share menu extensions

X-Pack services, such as the reporting features, register with the `share` plugin of the Kibana platform to register additional actions available to make content shareable.

### Generate a report job URL

To generate a new reporting job, different export types require different `jobParams` objects, which are Rison-encoded and used as a `jobParams` query string variable in the Reporting generation endpoint URL. If you use the aforementioned [Sharing plugin registrations](#reporting-share-service-registrations) then this detail will be abstracted away. If your application does not use the Share menu extensions, you will have to generate the URL and create a POST request to the URL.

### Basic job parameters

Certain fields of Reporting job parameters are required for every type of export.
```
interface BaseParams {
  title: string; 
  objectType: string; 
  browserTimezone: string; 
  version: string; 
};
```


### CSV


#### Job parameters of CsvSearchSource

The export type to generate CSV reports and is available in Discover uses "search source" objects. This export type is called `csv_searchsource` in the code. A configuration for a CSV report job is represented with an interface that includes the `BaseParams` and the following fields. To create a request for a CSV report, these required job parameters are Rison encoded into a query string variable of the report generation URL:
```
interface JobParamsCSV {
  searchSource: SerializedSearchSourceFields; 
  columns?: string[]; 
};
```


#### Job parameters of CsvFromSavedObject

A newer export type to generate CSV reports is available, currently only by API. This export type is called `csv_v2` in the code.
```
interface JobParamsCsvFromSavedObject {
  locatorParams: LocatorParams[]; 
};
```


#### Job payload

After the job parameters are received by the route handler for the report generation URL, an additional field is automatically added to the fields from job parameters:
```
interface TaskPayloadCSV {
  pagingStrategy: 'scan' | 'pit' 
}
```


### PDF and PNG


#### Job parameters

A configuration for a PDF or PNG report job is represented with an interface that includes the `BaseParams` and the following fields. To create a request for one of these report types, these required job parameters are encoded into a query string variable of the report generation URL:
```
interface BaseParamsPDFV2 {
  layout: {
    id: string; 
    dimensions: {
      height: number;
      width: number;
    };
  };
  locatorParams: LocatorParams[]; 
}

interface BaseParamsPNGV2 {
  layout: {
    id: string; 
    dimensions: {
      height: number;
      width: number;
    };
  };
  locatorParams: LocatorParams; 
}
```


#### How applications make themselves screenshot-capable

When generating the PDF, the headless browser launched by the Reporting export type runs a script that looks for a number of attributes in the DOM to determine which elements should have their screenshot taken and when the Visualizations are done rendering.
The print layout takes a screenshot of every element with the `data-shared-item` attribute and includes the individual screenshots in the PDF. The print layout also uses the `data-title` and `data-description` attributes on the same HTMLElement as the `data-shared-item` to specify the title and description.
The preserve layout takes a screenshot of the element with the `data-shared-items-container` attribute. Additionally, reporting will resize the element with the `data-shared-items-container` to be the size specified in the layout dimensions. The preserve layout also uses the `data-title` and `data-description` attributes on the HTMLElement with the `data-shared-items-container` attribute to specify the title/description for the entire PDF.
Reporting needs to determine when all of the visualizations have completed rendering, so that it can begin taking screenshots. If there are multiple visualizations, the `data-shared-items-count` attribute should be specified to let Reporting know how many Visualizations to look for. Reporting will look at every element with the `data-shared-item` attribute and use the corresponding `data-render-complete` attribute and `renderComplete` events to listen for rendering to complete. When rendering is complete for a visualization the `data-render-complete` attribute should be set to "true" and it should dispatch a custom DOM `renderComplete` event.
If the reporting job uses multiple URLs, before looking for any of the `data-shared-item` or `data-shared-items-count` attributes, it waits for a `data-shared-page` attribute that specifies which page is being loaded.

## Using POST URLs for debugging

Developers can capture a POST URL from a reporting-capable application to access the `jobParams` query string variable in the public API report generation endpoint. The query string variable can be passed through a URL de-encoder and then passed through a Rison-to-JSON converter to make the job parameters human-readable.
If attempting to send requests to the POST URL to test generating a report, use a shell script containing the curl command that POSTs the request. This will avoid any unintentional character escaping that can happen if running the curl command in an interactive shell.