﻿---
title: List of Kibana plugins
description: 
url: https://www.elastic.co/docs/extend/kibana/plugin-list
products:
  - Kibana
---

# List of Kibana plugins
## src/plugins


| Name                                                                                                                                                      | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
|-----------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [advancedSettings](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/advanced_settings/README.md)                                  | This plugin registers the management settings application allowing users to configure their advanced settings, also known as uiSettings within the code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [aiAssistantManagementSelection](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/ai_assistant_management/selection/README.md)     | The aiAssistantManagementSelection plugin manages the Ai Assistant management section.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| [charts](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/charts/README.md)                                                        | The Charts plugin is a way to create easier integration of shared colors, themes, types and other utilities across all Kibana charts and visualizations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [console](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/console/README.md)                                                      | Console provides the user with tools for storing and executing requests against Elasticsearch.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| [contentManagement](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/content_management/README.md)                                 | The content management plugin provides functionality to manage content in Kibana.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [controls](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/controls/README.mdx)                                                   | The Controls plugin contains Embeddables which can be used to add user-friendly interactivity to apps.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| [cps](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/cps/README.md)                                                              | Retrieves project tags from Elasticsearch using the /_project/tags endpoint.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| [customIntegrations](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/custom_integrations/README.md)                               | Register add-data cards                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| [dashboard](https://www.elastic.co/docs/extend/kibana/kibana-dashboard-plugin)                                                                            | - Registers the dashboard application. - Adds a dashboard embeddable that can be used in other applications.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| [dashboardMarkdown](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/dashboard_markdown/README.md)                                 | This plugin provides a simple Markdown component for embedding editable Markdown content in Kibana dashboards.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| [data](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/data/README.mdx)                                                           | The data plugin provides common data access services, such as search and query, for solutions and application developers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| [dataViewEditor](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/data_view_editor/README.md)                                      | Create data views from within Kibana apps.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| [dataViewFieldEditor](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/data_view_field_editor/README.md)                           | The reusable field editor across Kibana!                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [dataViewManagement](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/data_view_management)                                        | WARNING: Missing or empty README.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [dataViews](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/data_views/README.mdx)                                                | The data views API provides a consistent method of structuring and formatting documents and field lists across the various Kibana apps. It's typically used in conjunction with <DocLink id="kibDevTutorialDataSearchAndSessions" section="high-level-search" text="SearchSource" /> for composing queries.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| [developerToolbar](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/developer_toolbar/README.md)                                   | Plugin that enables the developer toolbar in Kibana development mode only. Other plugins can register custom items in the toolbar using the plugin contract.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| [devTools](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/dev_tools/README.md)                                                   | The ui/registry/dev_tools is removed in favor of the devTools plugin which exposes a register method in the setup contract. Registering app works mostly the same as registering apps in core.application.register. Routing will be handled by the id of the dev tool - your dev tool will be mounted when the URL matches /app/dev_tools#/<YOUR ID>. This API doesn't support angular, for registering angular dev tools, bootstrap a local module on mount into the given HTML element.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| [discover](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/discover/README.md)                                                    | Contains the Discover application and the saved search embeddable.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| [discoverShared](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/discover_shared/README.md)                                       | A stateful layer to register shared features and provide an access point to discover without a direct dependency.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [embeddable](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/embeddable/README.md)                                                | Kibana is a React application, and the minimum unit of sharing is the React component. Embeddables enforce this by requiring a React component during registration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| [esql](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/esql/README.md)                                                            | The editor accepts the following properties:                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| [esqlDataGrid](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/esql_datagrid/README.md)                                           | Contains a Discover-like table specifically for ES|QL queries:                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| [esUiShared](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/es_ui_shared/README.md)                                              | This plugin contains reusable code in the form of self-contained modules (or libraries). Each of these modules exports a set of functionality relevant to the domain of the module.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| [eventAnnotation](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/event_annotation/README.md)                                    | The Event Annotation service contains expressions for event annotations                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| [eventAnnotationListing](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/event_annotation_listing/README.md)                     | This plugin contains the library listing page for event annotation groups.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| [expressionGauge](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/chart_expressions/expression_gauge)                             | WARNING: Missing or empty README.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [expressionHeatmap](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/chart_expressions/expression_heatmap)                         | WARNING: Missing or empty README.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [expressionLegacyMetricVis](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/chart_expressions/expression_legacy_metric/README.md) | Expression MetricVis plugin adds a metric renderer and function to the expression plugin. The renderer will display the metric chart.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| [expressionMetricVis](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/chart_expressions/expression_metric/README.md)              | Expression MetricVis plugin adds a metric renderer and function to the expression plugin. The renderer will display the metric chart.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| [expressionPartitionVis](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/chart_expressions/expression_partition_vis/README.md)    | Expression Partition Visualization plugin adds a partitionVis renderer and pieVis, mosaicVis, treemapVis, waffleVis functions to the expression plugin. The renderer will display the pie, waffle, treemap and mosaic charts.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| [expressions](https://www.elastic.co/docs/extend/kibana/kibana-expressions-plugin)                                                                        | Expression pipeline is a chain of functions that *pipe* its output to the input of the next function. Functions can be configured using arguments provided by the user. The final output of the expression pipeline can be rendered using one of the *renderers* registered in `expressions` plugin.  All the arguments to expression functions need to be serializable, as well as input and output. Expression functions should try to stay 'pure'. This makes functions easy to reuse and also  make it possible to serialize the whole chain as well as output at every step of execution.  It is possible to add comments to expressions by starting them with a `//` sequence or by using `/*` and `*/` to enclose multi-line comments.  Expressions power visualizations in Dashboard and Lens, as well as, every *element* in Canvas is backed by an expression.  This plugin provides methods which will parse & execute an *expression pipeline* string for you, as well as a series of registries for advanced users who might want to incorporate their own functions, types, and renderers into the service for use in their own application. |
| [expressionTagcloud](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/chart_expressions/expression_tagcloud/README.md)             | Expression Tagcloud plugin adds a tagcloud renderer and function to the expression plugin. The renderer will display the Wordcloud chart.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| [expressionXY](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/chart_expressions/expression_xy/README.md)                         | Expression XY plugin adds a xy renderer and function to the expression plugin. The renderer will display the xy chart.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| [fieldFormats](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/field_formats/README.md)                                           | Index pattern fields formatters                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| [files](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/files/README.md)                                                          | The files service provides functionality to manage, retrieve, share files in Kibana.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| [filesManagement](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/files_management/README.md)                                    | Minimal interface for admins to manage files in Kibana.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| [ftrApis](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/ftr_apis/README.md)                                                    | This plugin exposes a set of APIs used internally during functional tests by the FTR.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| [home](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/home/README.md)                                                            | Moves the legacy ui/registry/feature_catalogue module for registering "features" that should be shown in the home page's feature catalogue to a service within a "home" plugin. The feature catalogue refered to here should not be confused with the "feature" plugin for registering features used to derive UI capabilities for feature controls.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| [imageEmbeddable](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/image_embeddable/README.md)                                    | This plugin contains image embeddable. Image embeddable allows to embed images into the dashboard. Images can be added either by URL or by uploading the image file via file service.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| [inputControlVis](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/input_control_vis/README.md)                                   | Contains the input control visualization allowing to place custom filter controls on a dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [inspectComponent](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/inspect_component/README.md)                                  | A developer tool for inspecting React components directly in the Kibana UI. It provides an overlay to highlight component boundaries and a flyout with detailed information and action buttons which let you open the component's source file in your preferred editor (VSCode, WebStorm, Cursor) or on GitHub/GitHub.dev.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| [inspector](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/inspector/README.md)                                                  | The inspector is a contextual tool to gain insights into different elements in Kibana, e.g. visualizations. It has the form of a flyout panel.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| [interactiveSetup](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/interactive_setup/README.md)                                  | This plugin provides UI and APIs for interactive setup mode a.k.a "enrollment flow".                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| [kibanaOverview](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/kibana_overview/README.md)                                      | An overview page highlighting Kibana apps                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| [kibanaReact](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/kibana_react/README.md)                                             | Tools for building React applications in Kibana.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| [kibanaUsageCollection](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/kibana_usage_collection/README.md)                       | This plugin registers the Platform Usage Collectors in Kibana.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| [kibanaUtils](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/kibana_utils/README.md)                                             | Utilities for building Kibana plugins.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| [kql](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/kql/README.md)                                                              | This plugin contains the kql autocomplete service and the UI KQL searchbar.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| [links](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/links/README.md)                                                         | This plugin adds the Links panel which allows authors to create hard links to navigate on click and bring all context from the source dashboard to the destination dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| [management](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/management/README.md)                                                | This plugins contains the "Stack Management" page framework. It offers navigation and an API to link individual management section into it. This plugin does not contain any individual management section itself.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| [mapsEms](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/maps_ems/README.md)                                                    | Utility plugin:                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| [navigation](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/navigation/README.md)                                                | The Navigation plugin provides essential navigation components and services for Kibana. It serves as a central hub for navigation-related functionality across the application.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| [newsfeed](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/newsfeed/README.md)                                                    | The newsfeed plugin adds a NewsfeedNavButton to the top navigation bar and renders the content in the flyout. Content is fetched from the remote ([https://feeds.elastic.co](https://feeds.elastic.co)) once a day, with periodic checks if the content needs to be refreshed. All newsfeed content is hosted remotely.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| [noDataPage](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/no_data_page/README.md)                                              | Helps to globally configure the no data page components                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| [presentationPanel](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/presentation_panel/README.md)                                | The Presentation Panel is the point of contact between any React component and any registered UI actions. Components provided to the Presentation Panel should use an imperative handle to expose methods and state.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| [presentationUtil](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/presentation_util/README.mdx)                                  | The Presentation Utility Plugin is a set of common, shared components and toolkits for solutions within the Presentation space, (e.g. Dashboards, Canvas).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| [savedObjects](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/saved_objects/README.md)                                           | NOTE: This plugin is deprecated and will be removed in 8.0. See [https://github.com/elastic/kibana/issues/46435](https://github.com/elastic/kibana/issues/46435) for more information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| [savedObjectsFinder](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/saved_objects_finder/README.md)                              | The savedObjectsFinder plugin exposes a UI for finding saved objects on the client side.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [savedObjectsManagement](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/saved_objects_management/README.md)                      | The savedObjectsManagement plugin manages the Saved Objects management section.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| [savedObjectsTaggingOss](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/saved_objects_tagging_oss/README.md)                     | Bridge plugin for consumption of the saved object tagging feature from oss plugins.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| [savedSearch](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/saved_search/README.md)                                             | Contains the saved search saved object definition and helpers. This object is created when a user saves their current session in the Discover app.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| [screenshotMode](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/screenshot_mode/README.md)                                       | The service exposed by this plugin informs consumers whether they should optimize for non-interactivity. In this way plugins can avoid loading unnecessary code, data or other services.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [share](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/share/README.mdx)                                                         | The share plugin contains various utilities for displaying sharing context menu, generating deep links to other apps using locators, and creating short URLs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| [telemetry](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/telemetry/README.md)                                                  | Telemetry allows Kibana features to have usage tracked in the wild. The general term "telemetry" refers to multiple things:                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| [telemetryCollectionManager](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/telemetry_collection_manager/README.md)              | Telemetry's collection manager to go through all the telemetry sources when fetching it before reporting.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| [telemetryManagementSection](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/telemetry_management_section/README.md)              | This plugin adds the Advanced Settings section for the Usage and Security Data collection (aka Telemetry).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| [uiActions](https://www.elastic.co/docs/extend/kibana/uiactions-plugin)                                                                                   | UI Actions plugins provides API to manage *triggers* and *actions*.  *Trigger* is an abstract description of user's intent to perform an action (like user clicking on a value inside chart). It allows us to do runtime binding between code from different plugins. For, example one such trigger is when somebody applies filters on dashboard; another one is when somebody opens a Dashboard panel context menu.  *Actions* are pieces of code that execute in response to a trigger. For example, to the dashboard filtering trigger multiple actions can be attached. Once a user filters on the dashboard all possible actions are displayed to the user in a popup menu and the user has to chose one.  In general this plugin provides:  - Creating custom functionality (actions). - Creating custom user interaction events (triggers). - Attaching and detaching actions to triggers. - Emitting trigger events. - Executing actions attached to a given trigger. - Exposing a context menu for the user to choose the appropriate action when there are multiple actions attached to a single trigger.                                       |
| [uiActionsEnhanced](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/ui_actions_enhanced/README.md)                                | Registers commercially licensed generic actions like per panel time range and contains some code that supports drilldown work.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| [unifiedDocViewer](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/unified_doc_viewer/README.md)                                  | This plugin contains services reliant on the plugin lifecycle for the unified doc viewer component (see @kbn/unified-doc-viewer).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [unifiedSearch](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/unified_search/README.md)                                         | Contains all the components of Kibana's unified search experience. Specifically:                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| [urlForwarding](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/url_forwarding/README.md)                                        | This plugins contains helpers to redirect legacy URLs. It can be used to forward old URLs to their new counterparts.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| [usageCollection](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/usage_collection/README.mdx)                                    | The Usage Collection Service defines a set of APIs for other plugins to report the usage of their features. At the same time, it provides necessary the APIs for other services (i.e.: telemetry, monitoring, ...) to consume that usage data.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| [visDefaultEditor](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/vis_default_editor/README.md)                                 | The default editor is used in most primary visualizations, e.x. Area, Data table, Pie, etc. It acts as a container for a particular visualization and options tabs. Contains the default "Data" tab in public/components/sidebar/data_tab.tsx. The plugin exposes the static DefaultEditorController class to consume.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| [visTypeGauge](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/vis_types/gauge)                                                  | WARNING: Missing or empty README.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [visTypeHeatmap](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/vis_types/heatmap)                                              | WARNING: Missing or empty README.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [visTypeMarkdown](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/vis_type_markdown/README.md)                                   | The markdown visualization that can be used to place text panels on dashboards.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| [visTypeMetric](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/vis_types/metric)                                                | WARNING: Missing or empty README.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [visTypePie](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/vis_types/pie)                                                      | WARNING: Missing or empty README.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [visTypeTable](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/vis_types/table/README.md)                                        | Contains the data table visualization, that allows presenting data in a simple table format.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| [visTypeTagcloud](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/vis_types/tagcloud)                                            | WARNING: Missing or empty README.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [visTypeTimelion](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/vis_types/timelion/README.md)                                  | Contains the timelion visualization and the timelion backend.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| [visTypeTimeseries](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/vis_types/timeseries)                                         | WARNING: Missing or empty README.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [visTypeVega](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/vis_types/vega)                                                    | WARNING: Missing or empty README.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [visTypeVislib](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/vis_types/vislib)                                                | WARNING: Missing or empty README.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [visTypeXy](https://github.com/elastic/kibana/blob/main/src/platform/plugins/private/vis_types/xy)                                                        | WARNING: Missing or empty README.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [visualizationListing](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/visualization_listing/README.md)                           | This plugin contains the library listing page for visualizations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [visualizations](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/visualizations)                                                  | WARNING: Missing or empty README.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [workflowsExecutionEngine](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/workflows_execution_engine/README.md)                  | Stateless execution engine for workflows.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| [workflowsExtensions](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/workflows_extensions/README.md)                             | Extension point registry for workflow extensions. This plugin provides a centralized location for registering custom workflow extensions, including step types.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| [workflowsManagement](https://github.com/elastic/kibana/blob/main/src/platform/plugins/shared/workflows_management/README.md)                             | This plugin contains the Workflows management application and APIs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |


## x-pack/plugins


| Name                                                                                                                                                              | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
|-------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [actions](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/actions/README.md)                                                           | The Kibana actions plugin provides a framework to create executable actions. You can:                                                                                                                                                                                                                                                                                                                                                                                                                               |
| [agentBuilder](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/agent_builder/README.md)                                                | Home of the Agent Builder framework.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| [agentBuilderPlatform](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/agent_builder_platform/README.md)                               | Contains the platform-owned agent builder entities                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| [aiops](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/aiops/README.md)                                                               | The plugin provides APIs and components for AIOps features, including the “Log rate analysis” UI, maintained by the ML team.                                                                                                                                                                                                                                                                                                                                                                                        |
| [alerting](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/alerting/README.md)                                                         | The Kibana Alerting plugin provides a common place to set up rules. You can:                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| [apm](https://github.com/elastic/kibana/blob/main/x-pack/solutions/observability/plugins/apm/readme.md)                                                           | This plugin provides access to App Monitoring features provided by Elastic. It allows you to monitor your software services and applications in real-time; visualize detailed performance information on your services, identify and analyze errors, and monitor host-level and APM agent-specific metrics like JVM and Go runtime metrics.                                                                                                                                                                         |
| [apmDataAccess](https://github.com/elastic/kibana/blob/main/x-pack/solutions/observability/plugins/apm_data_access)                                               | WARNING: Missing or empty README.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [apmSourcesAccess](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/apm_sources_access/README.md)                                       | Exposes services to access APM sources.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| [automaticImport](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/automatic_import/README.md)                                          | Team owner: Security Integrations Scalability                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| [automaticImportVTwo](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/automatic_import_v2/README.md)                                   | Team owner: Security Integration Experience                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| [banners](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/banners/README.md)                                                          | Allow to add a header banner that will be displayed on every page of the Kibana application                                                                                                                                                                                                                                                                                                                                                                                                                         |
| [canvas](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/canvas/README.md)                                                            | "Never look back. The past is done. The future is a blank canvas." ― Suzy Kassem, Rise Up and Salute the Sun                                                                                                                                                                                                                                                                                                                                                                                                        |
| [cases](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/cases/README.md)                                                               | This plugin provides cases management in Kibana                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| [cloud](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/cloud/README.md)                                                               | The cloud plugin exposes Cloud-specific metadata to Kibana.                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| [cloudChat](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/cloud_integrations/cloud_chat/README.md)                                  | The plugin was meant to integrate with DriftChat in order to provide live support to our Elastic Cloud users. It was removed, but the plugin was left behind to register no longer used config keys.                                                                                                                                                                                                                                                                                                                |
| [cloudConnect](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/cloud_connect/README.md)                                                | This plugin allows self-managed users to connect their cluster to an Elastic Cloud account, enabling cloud-managed services and features for self-managed deployments.                                                                                                                                                                                                                                                                                                                                              |
| [cloudDataMigration](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/cloud_integrations/cloud_data_migration/README.md)               | Static migration page where self-managed users can see text/copy about migrating to Elastic Cloud                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [cloudDefend](https://github.com/elastic/kibana/blob/main/x-pack/solutions/security/plugins/cloud_defend/README.md)                                               | This plugin currently only exists to provide custom fleet policy UX for a set of new BPF LSM features. The first feature being container "drift prevention".                                                                                                                                                                                                                                                                                                                                                        |
| [cloudExperiments](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/cloud_integrations/cloud_experiments/README.mdx)                   | [!NOTE] This plugin no-longer exposes any evaluation APIs. Refer to <DocLink id="kibFeatureFlagsService" /> for more information about how to interact with feature flags.                                                                                                                                                                                                                                                                                                                                          |
| [cloudFullStory](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/cloud_integrations/cloud_full_story/README.md)                       | Integrates with FullStory in order to provide better product analytics, so we can understand how our users make use of Kibana. This plugin should only run on Elastic Cloud.                                                                                                                                                                                                                                                                                                                                        |
| [cloudLinks](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/cloud_integrations/cloud_links/README.md)                                | Adds all the links to the Elastic Cloud console.                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| [cloudSecurityPosture](https://github.com/elastic/kibana/blob/main/x-pack/solutions/security/plugins/cloud_security_posture/README.md)                            | Cloud Posture automates the identification and remediation of risks across cloud infrastructures                                                                                                                                                                                                                                                                                                                                                                                                                    |
| [contentConnectors](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/content_connectors/README.mdx)                                     | This plugin contains common assets and endpoints for the use of connectors in Kibana. Primarily used by the enterprise_search and serverless_search plugins.                                                                                                                                                                                                                                                                                                                                                        |
| [crossClusterReplication](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/cross_cluster_replication/README.md)                        | You can run a local cluster and simulate a remote cluster within a single Kibana directory.                                                                                                                                                                                                                                                                                                                                                                                                                         |
| [customBranding](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/custom_branding/README.md)                                           | This is a plugin to configure custom branding. Plugin server-side only. Plugin has three main functions:                                                                                                                                                                                                                                                                                                                                                                                                            |
| [dashboardAgent](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/dashboard_agent/README.md)                                            | Server-side plugin that provides a specialized AI agent and tools for dashboard management via the AgentBuilder framework.                                                                                                                                                                                                                                                                                                                                                                                          |
| [dashboardEnhanced](https://www.elastic.co/docs/extend/kibana/dashboard-enhanced-plugin)                                                                          | Adds drilldown capabilities to dashboard.  Owned by the Kibana App team.                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| [dataCatalog](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/data_catalog/README.md)                                                  | A Kibana plugin providing a common abstraction (Data Source) for content connectors and federated connectors, as well as additional future data sources needed by O11y/Security solutions for chat.                                                                                                                                                                                                                                                                                                                 |
| [dataQuality](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/data_quality/README.md)                                                  | Page where users can see the quality of their log data sets.                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| [datasetQuality](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/dataset_quality/README.md)                                            | In order to make ongoing maintenance of log collection easy we want to introduce the concept of data set quality, where users can easily get an overview on the data sets they have with information such as integration, size, last activity, among others.                                                                                                                                                                                                                                                        |
| [dataSources](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/data_sources/README.md)                                                  | Home of the Data Sources plugin.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| [dataUsage](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/data_usage/README.md)                                                     | Serverless-only plugin for users to view data usage. Available in all 3 solutions.                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| [dataVisualizer](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/data_visualizer/README.md)                                           | The data_visualizer plugin enables you to explore the fields in your data.                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [discoverEnhanced](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/discover_enhanced/README.md)                                       | Contains the enhancements to the OSS discover app.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| [ecsDataQualityDashboard](https://github.com/elastic/kibana/blob/main/x-pack/solutions/security/plugins/ecs_data_quality_dashboard/README.md)                     | This plugin implements (server) APIs used to render the content of the Data Quality dashboard.                                                                                                                                                                                                                                                                                                                                                                                                                      |
| [elasticAssistant](https://github.com/elastic/kibana/blob/main/x-pack/solutions/security/plugins/elastic_assistant/README.md)                                     | This plugin implements server APIs for the Elastic AI Assistant. Furthermore, it registers the Elastic Assistant in the navigation bar.                                                                                                                                                                                                                                                                                                                                                                             |
| [elasticAssistantSharedState](https://github.com/elastic/kibana/blob/main/x-pack/solutions/security/plugins/elastic_assistant_shared_state/README.md)             | This plugin acts as a reactive bridge between the elastic assistant plugin and other plugins. It exposes an RxJS-based interface where:                                                                                                                                                                                                                                                                                                                                                                             |
| [embeddableAlertsTable](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/embeddable_alerts_table/README.md)                             | Embeddable wrapper for the alerts table                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| [embeddableEnhanced](https://www.elastic.co/docs/extend/kibana/enhanced-embeddables-plugin)                                                                       | Enhances Embeddables by registering a custom factory provider. The enhanced factory provider adds dynamic actions to every embeddables state, in order to support drilldowns.                                                                                                                                                                                                                                                                                                                                       |
| [encryptedSavedObjects](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/encrypted_saved_objects/README.md)                             | The purpose of this plugin is to provide a way to encrypt/decrypt attributes on the custom Saved Objects that works with security and spaces filtering.                                                                                                                                                                                                                                                                                                                                                             |
| [enterpriseSearch](https://github.com/elastic/kibana/blob/main/x-pack/solutions/search/plugins/enterprise_search/README.md)                                       | This plugin provides Kibana user interfaces for managing the Enterprise Search solution and its products, App Search and Workplace Search.                                                                                                                                                                                                                                                                                                                                                                          |
| [entityManager](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/entity_manager/README.md)                                              | This plugin provides access to observed entity data, such as information about hosts, pods, containers, services, and more.                                                                                                                                                                                                                                                                                                                                                                                         |
| [entityStore](https://github.com/elastic/kibana/blob/main/x-pack/solutions/security/plugins/entity_store/README.md)                                               | Central place for Entities management and logs extraction                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| [eventLog](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/event_log/README.md)                                                        | The event log plugin provides a persistent history of alerting and action activities.                                                                                                                                                                                                                                                                                                                                                                                                                               |
| [exploratoryView](https://github.com/elastic/kibana/blob/main/x-pack/solutions/observability/plugins/exploratory_view/README.md)                                  | A shared component for visualizing observability data types via lens embeddable. For further details.                                                                                                                                                                                                                                                                                                                                                                                                               |
| [features](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/features/README.md)                                                         | The features plugin enhance Kibana with a per-feature privilege system.                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| [feedback](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/feedback/README.md)                                                        | Universal way of giving feedback about Elastic in Kibana.                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| [fieldsMetadata](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/fields_metadata/README.md)                                            | The @kbn/fields-metadata-plugin is designed to provide a centralized and asynchronous way to consume field metadata across Kibana. This plugin addresses the need for on-demand retrieval of field metadata from static ECS/Metadata definitions and integration manifests, with the flexibility to extend to additional resolution sources in the future.                                                                                                                                                          |
| [fileUpload](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/file_upload)                                                             | WARNING: Missing or empty README.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [fleet](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/fleet/README.md)                                                               | Fleet provides a web-based UI in Kibana for centrally managing Elastic Agents and their policies.                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [genAiSettings](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/gen_ai_settings/README.md)                                            | This plugin provides a management interface for configuring generative AI settings within Kibana's Stack Management section.                                                                                                                                                                                                                                                                                                                                                                                        |
| [globalSearch](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/global_search/README.md)                                                | The GlobalSearch plugin provides an easy way to search for various objects, such as applications or dashboards from the Kibana instance, from both server and client-side plugins                                                                                                                                                                                                                                                                                                                                   |
| [globalSearchBar](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/global_search_bar/README.md)                                        | The GlobalSearchBar plugin provides a search interface for navigating Kibana. (It is the UI to the GlobalSearch plugin.)                                                                                                                                                                                                                                                                                                                                                                                            |
| [globalSearchProviders](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/global_search_providers/README.md)                            | The globalSearchProviders plugin provides Kibana default search providers for the GlobalSearch plugin.                                                                                                                                                                                                                                                                                                                                                                                                              |
| [graph](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/graph/README.md)                                                              | This is the main source folder of the Graph plugin. It contains all of the Kibana server and client source code. x-pack/platform/test/functional/apps/graph contains additional functional tests.                                                                                                                                                                                                                                                                                                                   |
| [grokdebugger](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/grokdebugger/README.md)                                                | This plugin helps users define Grok patterns, which are particularly useful for ingesting logs.                                                                                                                                                                                                                                                                                                                                                                                                                     |
| [indexLifecycleManagement](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/index_lifecycle_management/README.md)                      | You can test that the Frozen badge, phase filtering, and lifecycle information is surfaced in Index Management by running this series of requests in Console:                                                                                                                                                                                                                                                                                                                                                       |
| [indexManagement](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/index_management/README.md)                                          | This service is exposed from the Index Management setup contract and can be used to add content to the indices list and the index details page.                                                                                                                                                                                                                                                                                                                                                                     |
| [indicesMetadata](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/indices_metadata/README.md)                                         | Plugin for managing and retrieving metadata about indices in Kibana. This plugin collects and processes metadata from Elasticsearch indices, data streams, ILM policies, and index templates.                                                                                                                                                                                                                                                                                                                       |
| [inference](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/inference/README.md)                                                       | The inference plugin is a central place to handle all interactions with the Elasticsearch Inference API and external LLM APIs. Its goals are:                                                                                                                                                                                                                                                                                                                                                                       |
| [inferenceEndpoint](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/inference_endpoint/README.md)                                      | A Kibana plugin                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| [infra](https://github.com/elastic/kibana/blob/main/x-pack/solutions/observability/plugins/infra/README.md)                                                       | This is the home of the infra plugin, which aims to provide a solution for the infrastructure monitoring use-case within Kibana.                                                                                                                                                                                                                                                                                                                                                                                    |
| [ingestPipelines](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/ingest_pipelines/README.md)                                          | The ingest_pipelines plugin provides Kibana support for Elasticsearch's ingest pipelines.                                                                                                                                                                                                                                                                                                                                                                                                                           |
| [intercepts](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/intercepts/README.md)                                                    | Contains business logic and orchestration for displaying the intercept dialog suited to the needs of Kibana, and is made available so that other solution teams might leverage this to register and schedule an intercept of their choosing                                                                                                                                                                                                                                                                         |
| [kubernetesSecurity](https://github.com/elastic/kibana/blob/main/x-pack/solutions/security/plugins/kubernetes_security/README.md)                                 | This plugin provides interactive visualizations of your Kubernetes workload and session data.                                                                                                                                                                                                                                                                                                                                                                                                                       |
| [lens](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/lens/readme.md)                                                                 | Lens is a visualization editor allowing to quickly and easily configure compelling visualizations to use on dashboards and canvas workpads.                                                                                                                                                                                                                                                                                                                                                                         |
| [licenseApiGuard](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/license_api_guard/README.md)                                        | This plugin is used by ES UI plugins to reject API requests when the plugin is unsupported by the user's license.                                                                                                                                                                                                                                                                                                                                                                                                   |
| [licenseManagement](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/license_management/README.md)                                      | This plugin enables users to activate a trial license, downgrade to Basic, and upload a new license.                                                                                                                                                                                                                                                                                                                                                                                                                |
| [licensing](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/licensing/README.md)                                                       | The licensing plugin retrieves license data from Elasticsearch at regular configurable intervals.                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [lists](https://github.com/elastic/kibana/blob/main/x-pack/solutions/security/plugins/lists/README.md)                                                            | README.md for developers working on the backend lists on how to get started using the CURL scripts in the scripts folder.                                                                                                                                                                                                                                                                                                                                                                                           |
| [llmTasks](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/ai_infra/llm_tasks/README.md)                                               | This plugin contains various LLM tasks.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| [logsDataAccess](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/logs_data_access/README.md)                                           | Exposes services to access logs data.                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| [logsShared](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/logs_shared/README.md)                                                    | Exposes the shared components and APIs to access and visualize logs.                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| [logstash](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/logstash)                                                                  | WARNING: Missing or empty README.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [maintenanceWindows](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/maintenance_windows/README.md)                                    | A Kibana plugin providing functionalities to manage maintenance windows.                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| [maps](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/maps/README.md)                                                                 | Visualize geo data from Elasticsearch or 3rd party geo-services.                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| [metricsDataAccess](https://github.com/elastic/kibana/blob/main/x-pack/solutions/observability/plugins/metrics_data_access/README.md)                             | Exposes utilities to access metrics data.                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| [ml](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/ml/readme.md)                                                                     | This plugin provides access to the machine learning features provided by Elastic.                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [monitoring](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/monitoring/readme.md)                                                    | This plugin provides the Stack Monitoring kibana application.                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| [monitoringCollection](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/monitoring_collection/README.md)                               | This plugin allows for other plugins to add data to Kibana stack monitoring documents.                                                                                                                                                                                                                                                                                                                                                                                                                              |
| [notifications](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/notifications/README.mdx)                                              | The Notifications plugin provides a set of services to help Solutions and plugins send notifications to users.                                                                                                                                                                                                                                                                                                                                                                                                      |
| [observability](https://github.com/elastic/kibana/blob/main/x-pack/solutions/observability/plugins/observability/README.md)                                       | This plugin provides shared components and services for use across observability solutions, as well as the observability landing page UI.                                                                                                                                                                                                                                                                                                                                                                           |
| [observabilityAgentBuilder](https://github.com/elastic/kibana/blob/main/x-pack/solutions/observability/plugins/observability_agent_builder/README.md)             | This plugin provides an observability agent, observability tools and attachments for Agent Builder.                                                                                                                                                                                                                                                                                                                                                                                                                 |
| [observabilityAIAssistant](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/observability_ai_assistant/README.md)                       | This document gives an overview of the features of the Observability AI Assistant at the time of writing, and how to use them. At a high level, the Observability AI Assistant offers contextual insights, and a chat functionality that we enrich with function calling, allowing the LLM to hook into the user's data. We also allow the LLM to store things it considers new information as embeddings into Elasticsearch, and query this knowledge base when it decides it needs more information, using ELSER. |
| [observabilityAIAssistantApp](https://github.com/elastic/kibana/blob/main/x-pack/solutions/observability/plugins/observability_ai_assistant_app/README.md)        | This app registers defaults functions. It exists as a separate plugin to avoid cyclical dependencies.                                                                                                                                                                                                                                                                                                                                                                                                               |
| [observabilityAiAssistantManagement](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/observability_ai_assistant_management/README.md) | The observabilityAiAssistantManagement plugin manages the Ai Assistant for Observability and Search management section.                                                                                                                                                                                                                                                                                                                                                                                             |
| [observabilityLogsExplorer](https://github.com/elastic/kibana/blob/main/x-pack/solutions/observability/plugins/observability_logs_explorer/README.md)             | This plugin provides an app based on the LogsExplorer component from the logs_explorer plugin, but adds observability-specific affordances.                                                                                                                                                                                                                                                                                                                                                                         |
| [observabilityOnboarding](https://github.com/elastic/kibana/blob/main/x-pack/solutions/observability/plugins/observability_onboarding/README.md)                  | This plugin provides an onboarding framework for observability solutions: Logs and APM.                                                                                                                                                                                                                                                                                                                                                                                                                             |
| [observabilityShared](https://github.com/elastic/kibana/blob/main/x-pack/solutions/observability/plugins/observability_shared/README.md)                          | A plugin that contains components and utilities shared by all Observability plugins.                                                                                                                                                                                                                                                                                                                                                                                                                                |
| [osquery](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/osquery/README.md)                                                           | This plugin adds extended support to Security Solution Fleet Osquery integration                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| [painlessLab](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/painless_lab/README.md)                                                 | This plugin helps users learn how to use the Painless scripting language.                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| [productDocBase](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/ai_infra/product_doc_base/README.md)                                  | This plugin provides APIs to install, update, and uninstall knowledge base artifacts for AI Assistants. It supports two resource types:                                                                                                                                                                                                                                                                                                                                                                             |
| [productIntercept](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/product_intercept/README.md)                                       | This is a standalone plugin that leverages the intercept plugin to display product intercept used to gather information that is turn used to compute CSAT about user's experience of Kibana.                                                                                                                                                                                                                                                                                                                        |
| [profiling](https://github.com/elastic/kibana/blob/main/x-pack/solutions/observability/plugins/profiling/README.md)                                               | Universal Profiling provides fleet-wide, whole-system, continuous profiling with zero instrumentation. Get a comprehensive understanding of what lines of code are consuming compute resources throughout your entire fleet by visualizing your data in Kibana using the flamegraph, stacktraces, and top functions views.                                                                                                                                                                                          |
| [profilingDataAccess](https://github.com/elastic/kibana/blob/main/x-pack/solutions/observability/plugins/profiling_data_access)                                   | WARNING: Missing or empty README.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [reindexService](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/reindex_service/README.md)                                           | Reindexing as a service                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| [remoteClusters](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/remote_clusters/README.md)                                           | This plugin helps users manage their remote clusters, which enable cross-cluster search and cross-cluster replication.                                                                                                                                                                                                                                                                                                                                                                                              |
| [reporting](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/reporting/README.md)                                                      | An awesome Kibana reporting plugin                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| [rollup](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/rollup/README.md)                                                            | Welcome to the Kibana rollup plugin! This plugin provides Kibana support for Elasticsearch's rollup feature. Please refer to the Elasticsearch documentation to understand rollup indices and how to create rollup jobs.                                                                                                                                                                                                                                                                                            |
| [ruleRegistry](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/rule_registry/README.md)                                                | The rule registry plugin aims to make it easy for rule type producers to have their rules produce the data that they need to build rich experiences on top of a unified experience, without the risk of mapping conflicts.                                                                                                                                                                                                                                                                                          |
| [runtimeFields](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/runtime_fields/README.md)                                             | Welcome to the home of the runtime field editor and everything related to runtime fields!                                                                                                                                                                                                                                                                                                                                                                                                                           |
| [sampleDataIngest](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/sample_data_ingest/README.md)                                       | A service for creating and managing sample data sets in Elasticsearch indices. Supports sample types and automated data ingestion.                                                                                                                                                                                                                                                                                                                                                                                  |
| [savedObjectsTagging](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/saved_objects_tagging/README.md)                                 | Add tagging capability to saved objects                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| [screenshotting](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/screenshotting/README.md)                                             | This plugin provides functionality to take screenshots of the Kibana pages. It uses Chromium and Puppeteer underneath to run the browser in headless mode.                                                                                                                                                                                                                                                                                                                                                          |
| [searchAssistant](https://github.com/elastic/kibana/blob/main/x-pack/solutions/search/plugins/search_assistant/README.md)                                         | This holds the Search AI Assistant which targets Search users and Serverless Elasticsearch.                                                                                                                                                                                                                                                                                                                                                                                                                         |
| [searchGettingStarted](https://github.com/elastic/kibana/blob/main/x-pack/solutions/search/plugins/search_getting_started)                                        | WARNING: Missing or empty README.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [searchHomepage](https://github.com/elastic/kibana/blob/main/x-pack/solutions/search/plugins/search_homepage/README.mdx)                                          | The Search Homepage is a shared homepage for elasticsearch users.                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [searchIndices](https://github.com/elastic/kibana/blob/main/x-pack/solutions/search/plugins/search_indices/README.mdx)                                            | The Search Indices plugin is a shared set of pages for elasticsearch users across stack and serverless search solutions.                                                                                                                                                                                                                                                                                                                                                                                            |
| [searchInferenceEndpoints](https://github.com/elastic/kibana/blob/main/x-pack/solutions/search/plugins/search_inference_endpoints/README.md)                      | The Inference Endpoints is a tool used to manage inference endpoints                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| [searchNavigation](https://github.com/elastic/kibana/blob/main/x-pack/solutions/search/plugins/search_navigation/README.mdx)                                      | The Search Navigation plugin is used to handle navigation for search solution plugins across both stack and serverless.                                                                                                                                                                                                                                                                                                                                                                                             |
| [searchNotebooks](https://github.com/elastic/kibana/blob/main/x-pack/solutions/search/plugins/search_notebooks/README.mdx)                                        | This plugin contains endpoints and components for rendering search python notebooks in the persistent dev console.                                                                                                                                                                                                                                                                                                                                                                                                  |
| [searchPlayground](https://github.com/elastic/kibana/blob/main/x-pack/solutions/search/plugins/search_playground/README.md)                                       | The Search Playground is a tool for developers to experiment with their own data using LLMs.                                                                                                                                                                                                                                                                                                                                                                                                                        |
| [searchprofiler](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/searchprofiler/README.md)                                             | The search profiler consumes the Profile API by sending a search API with profile: true enabled in the request body. The response contains detailed information on how Elasticsearch executed the search request. People use this information to understand why a search request might be slow.                                                                                                                                                                                                                     |
| [searchQueryRules](https://github.com/elastic/kibana/blob/main/x-pack/solutions/search/plugins/search_query_rules/README.md)                                      | A plugin to manage Query Rules in Elasticsearch through Query Rules API                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| [searchSynonyms](https://github.com/elastic/kibana/blob/main/x-pack/solutions/search/plugins/search_synonyms/README.md)                                           | A plugin to manage synonyms in Elasticsearch through Synonyms APIs through Kibana.                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| [security](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/security/README.md)                                                         | See Configuring security in Kibana.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| [securitySolution](https://github.com/elastic/kibana/blob/main/x-pack/solutions/security/plugins/security_solution/README.md)                                     | Welcome to the Kibana Security Solution plugin! This README will go over getting started with development and testing.                                                                                                                                                                                                                                                                                                                                                                                              |
| [securitySolutionEss](https://github.com/elastic/kibana/blob/main/x-pack/solutions/security/plugins/security_solution_ess/README.md)                              | The security_solution_ess plugin is an internal plugin for Kibana's Security Solution, designed to encapsulate ESS-specific logic. This plugin is only enabled when the application is built for stateful deployments (ESS or on-prem), keeping the main security_solution plugin clean and agnostic of the offering model.                                                                                                                                                                                         |
| [securitySolutionServerless](https://github.com/elastic/kibana/blob/main/x-pack/solutions/security/plugins/security_solution_serverless/README.md)                | The security_solution_serverless plugin is an internal plugin for Kibana's Security Solution, designed to encapsulate serverless-specific logic. This plugin is only enabled when the application is built for serverless project, keeping the main security_solution plugin clean and agnostic of the offering model.                                                                                                                                                                                              |
| [serverless](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/serverless/README.mdx)                                                    | WARNING: Missing or empty README.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [serverlessObservability](https://github.com/elastic/kibana/blob/main/x-pack/solutions/observability/plugins/serverless_observability/README.mdx)                 | This plugin contains configuration and code used to create a Serverless Observability project.  It leverages universal configuration and other APIs in the serverless plugin to configure Kibana.                                                                                                                                                                                                                                                                                                                   |
| [serverlessSearch](https://github.com/elastic/kibana/blob/main/x-pack/solutions/search/plugins/serverless_search/README.mdx)                                      | This plugin contains configuration and code used to create a Serverless Search project. It leverages universal configuration and other APIs in the serverless plugin to configure Kibana.                                                                                                                                                                                                                                                                                                                           |
| [serverlessWorkplaceAI](https://github.com/elastic/kibana/blob/main/x-pack/solutions/workplaceai/plugins/serverless_workplace_ai/README.mdx)                      | The serverlessWorkplaceAI plugin is an internal plugin for Kibana's Workplace AI Solution.                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [sessionView](https://github.com/elastic/kibana/blob/main/x-pack/solutions/security/plugins/session_view/README.md)                                               | Session View is meant to provide a visualization into what is going on in a particular Linux environment where the agent is running. It looks likes a terminal emulator; however, it is a tool for introspecting process activity and understanding user and service behaviour in your Linux servers and infrastructure. It is a time-ordered series of process executions displayed in a tree over time.                                                                                                           |
| [slo](https://github.com/elastic/kibana/blob/main/x-pack/solutions/observability/plugins/slo/README.md)                                                           | A Kibana plugin                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| [sloShared](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/slo_shared/README.md)                                                      | This plugin provides shared SLO functionality that can be consumed by multiple plugins (e.g., SLO, Fleet).                                                                                                                                                                                                                                                                                                                                                                                                          |
| [snapshotRestore](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/snapshot_restore/README.md)                                         | or                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| [spaces](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/spaces/README.md)                                                             | See Configuring Kibana Spaces.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| [stackAlerts](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/stack_alerts/README.md)                                                  | This plugin provides alertTypes shipped with Kibana for use with the the alerting plugin.  When enabled, it will register the alertTypes by the Stack in the alerting plugin, register associated HTTP routes, etc.                                                                                                                                                                                                                                                                                                 |
| [stackConnectors](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/stack_connectors/README.md)                                          | The stack_connectors plugin provides connector types shipped with Kibana, built on top of the framework provided in the actions plugin.                                                                                                                                                                                                                                                                                                                                                                             |
| [streams](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/streams/README.md)                                                           | This plugin provides an interface to manage streams                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| [streamsApp](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/streams_app/README.md)                                                    | Home of the Streams app plugin, which allows users to manage Streams via the UI.                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| [synthetics](https://github.com/elastic/kibana/blob/main/x-pack/solutions/observability/plugins/synthetics/README.md)                                             | The purpose of this plugin is to provide users of Heartbeat more visibility of what's happening in their infrastructure.                                                                                                                                                                                                                                                                                                                                                                                            |
| [taskManager](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/task_manager/README.md)                                                  | The task manager is a generic system for running background tasks.                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| [taskManagerDependencies](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/task_manager_dependencies/README.md)                        | This plugin is used as a temporary sidecar plugin to enable the task manager plugin access to the encrypted saved objects client and the security plugin start contract as there is a circular dependency if the task manager were to require the encrypted saved objects plugin directly.                                                                                                                                                                                                                          |
| [telemetryCollectionXpack](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/telemetry_collection_xpack/README.md)                      | Gathers all usage collection, retrieving them from both: OSS and X-Pack plugins.                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| [timelines](https://github.com/elastic/kibana/blob/main/x-pack/solutions/security/plugins/timelines/README.md)                                                    | Timelines is a plugin that provides a grid component with accompanying server side apis to help users identify events of interest and perform root cause analysis within Kibana.                                                                                                                                                                                                                                                                                                                                    |
| [transform](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/transform/README.md)                                                      | This plugin provides access to the transforms features provided by Elasticsearch. It follows Kibana's standard plugin architecture, originally the plugin boilerplate code was taken from the snapshot/restore plugin.                                                                                                                                                                                                                                                                                              |
| [translations](https://www.elastic.co/docs/extend/kibana/translations-plugin)                                                                                     | Contains Elastic-supported translations. Owned by the Localizations team. For adding localizations and instrument a ui to support translated content, see [https://github.com/elastic/kibana/tree/main/src/platform/packages/shared/kbn-i18n](https://github.com/elastic/kibana/tree/main/src/platform/packages/shared/kbn-i18n)                                                                                                                                                                                    |
| [triggersActionsUi](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/triggers_actions_ui/README.md)                                     | The Kibana alerts and actions UI plugin provides a user interface for managing alerts and actions. As a developer you can reuse and extend built-in alerts and actions UI functionality:                                                                                                                                                                                                                                                                                                                            |
| [upgradeAssistant](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/upgrade_assistant/README.md)                                       | Upgrade Assistant helps users prepare their Stack for being upgraded to the next version of the Elastic stack.                                                                                                                                                                                                                                                                                                                                                                                                      |
| [uptime](https://github.com/elastic/kibana/blob/main/x-pack/solutions/observability/plugins/uptime/README.md)                                                     | The purpose of this plugin is to provide users of Heartbeat more visibility of what's happening in their infrastructure.                                                                                                                                                                                                                                                                                                                                                                                            |
| [urlDrilldown](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/drilldowns/url_drilldown/README.md)                                    | NOTE: This plugin contains implementation of URL drilldown. For drilldowns infrastructure code refer to ui_actions_enhanced plugin.                                                                                                                                                                                                                                                                                                                                                                                 |
| [usageApi](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/shared/usage_api/README.md)                                                        | This plugin is used to report Usage metrics to our Cloud internal Usage API.                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| [ux](https://github.com/elastic/kibana/blob/main/x-pack/solutions/observability/plugins/ux/readme.md)                                                             | [https://docs.elastic.dev/kibana-dev-docs/welcome](https://docs.elastic.dev/kibana-dev-docs/welcome)                                                                                                                                                                                                                                                                                                                                                                                                                |
| [watcher](https://github.com/elastic/kibana/blob/main/x-pack/platform/plugins/private/watcher/README.md)                                                          | This plugins adopts some conventions in addition to or in place of conventions in Kibana (at the time of the plugin's creation):                                                                                                                                                                                                                                                                                                                                                                                    |
| [workplaceAIApp](https://github.com/elastic/kibana/blob/main/x-pack/solutions/workplaceai/plugins/workplace_ai_app/README.md)                                     | Workplace AI application plugin                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |