﻿---
title: Logging configuration changes
description: 
url: https://www.elastic.co/docs/extend/kibana/logging-config-changes
products:
  - Kibana
---

# Logging configuration changes
<warning>
  Kibana 8.0.0 and later uses a new logging system. Before you upgrade, read the documentation for your Kibana version.
</warning>



| Parameter  | Log record in **pattern*** format          | Legacy log record in ***text** format |
|------------|--------------------------------------------|---------------------------------------|
| @timestamp | ISO8601_TZ `2012-01-31T23:33:22.011-05:00` | Absolute `23:33:22.011`               |
| logger     | `parent.child`                             | `['parent', 'child']`                 |
| level      | `DEBUG`                                    | `['debug']`                           |
| meta       | stringified JSON object `{"to": "v8"}`     | N/A                                   |
| pid        | can be configured as `%pid`                | N/A                                   |



| Parameter  | Log record in **json*** format             | Legacy log record ***json** format       |
|------------|--------------------------------------------|------------------------------------------|
| @timestamp | ISO8601_TZ `2012-01-31T23:33:22.011-05:00` | ISO8601 `2012-01-31T23:33:22.011Z`       |
| logger     | `log.logger: parent.child`                 | `tags: ['parent', 'child']`              |
| level      | `log.level: DEBUG`                         | `tags: ['debug']`                        |
| meta       | merged in log record  `{... "to": "v8"}`   | merged in log record  `{... "to": "v8"}` |
| pid        | `process.pid: 12345`                       | `pid: 12345`                             |
| type       | N/A                                        | `type: log`                              |
| error      | `{ message, name, stack }`                 | `{ message, name, stack, code, signal }` |