﻿---
title: Kibana Core API
description: Kibana Core provides a set of low-level API’s required to run all Kibana plugins. These API’s are injected into your plugin’s lifecycle methods and may...
url: https://www.elastic.co/docs/extend/kibana/kibana-platform-api
products:
  - Kibana
---

# Kibana Core API
<warning>
  This functionality is in technical preview and may be changed or removed in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.
</warning>

Kibana Core provides a set of low-level API’s required to run all Kibana plugins. These API’s are injected into your plugin’s lifecycle methods and may be invoked during that lifecycle only:
```typescript
import type { PluginInitializerContext, CoreSetup, CoreStart } from '@kbn/core/server';

export class MyPlugin {
  constructor(initializerContext: PluginInitializerContext) {}

  public setup(core: CoreSetup) {
    // called when plugin is setting up during Kibana's startup sequence
  }

  public start(core: CoreStart) {
    // called after all plugins are set up
  }

  public stop() {
    // called when plugin is torn down during Kibana's shutdown sequence
  }
}
```

The services that core provides are:
- [Application service](https://www.elastic.co/docs/extend/kibana/application-service)
- [Configuration service](https://www.elastic.co/docs/extend/kibana/configuration-service)
- [Elasticsearch service](https://www.elastic.co/docs/extend/kibana/elasticsearch-service)
- [HTTP service](https://www.elastic.co/docs/extend/kibana/http-service)
- [Logging service](https://www.elastic.co/docs/extend/kibana/logging-service)
- [Saved Objects service](https://www.elastic.co/docs/extend/kibana/saved-objects)
- [UI settings service](https://www.elastic.co/docs/extend/kibana/ui-settings-service)

<note>
  Core provides the Kibana building blocks for plugins and is implemented as a collection of [packages](https://www.elastic.co/docs/extend/kibana/core-packages).
</note>